/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.bootstrap;

import com.newrelic.agent.config.IBMUtils;
import com.newrelic.bootstrap.BootstrapLoader;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Collection;

public class BootstrapAgent {
    public static final String AGENT_CLASS_NAME = "com.newrelic.agent.Agent";
    private static final String WS_SERVER_JAR = "ws-server.jar";
    private static final String WS_LOG_MANAGER = "com.ibm.ws.kernel.boot.logging.WsLogManager";
    private static final String IBM_VENDOR = "IBM";

    public static URL getAgentJarUrl() {
        return BootstrapAgent.class.getProtectionDomain().getCodeSource().getLocation();
    }

    public static void main(String[] args) {
        try {
            Collection<URL> urls = BootstrapLoader.getJarURLs();
            urls.add(BootstrapAgent.getAgentJarUrl());
            urls.add(BootstrapAgent.class.getProtectionDomain().getCodeSource().getLocation());
            URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[0]), null);
            Class<?> agentClass = classLoader.loadClass(AGENT_CLASS_NAME);
            Method main = agentClass.getDeclaredMethod("main", String[].class);
            main.invoke(null, new Object[]{args});
        }
        catch (Throwable t) {
            System.err.println(MessageFormat.format("Error invoking the New Relic command: {0}", t));
            t.printStackTrace();
        }
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        String javaVersion = System.getProperty("java.version", "");
        if (javaVersion.startsWith("1.5")) {
            String msg = MessageFormat.format("Java version is: {0}.  This version of the New Relic Agent does not support Java 1.5.  Please use a 2.21.x New Relic agent or a later version of Java.", javaVersion);
            System.err.println("----------");
            System.err.println(msg);
            System.err.println("----------");
            return;
        }
        if (javaVersion.startsWith("9")) {
            boolean java9enabled;
            boolean bl = java9enabled = System.getProperty("newrelic.enable.java.9") != null;
            if (!java9enabled) {
                String msg = MessageFormat.format("Java version is: {0}.  This version of the New Relic Agent does not support Java 9. Please use an earlier version of Java.", javaVersion);
                System.err.println("----------");
                System.err.println(msg);
                System.err.println("----------");
                return;
            }
        }
        BootstrapAgent.checkAndApplyIBMLibertyProfileLogManagerWorkaround();
        BootstrapAgent.startAgent(agentArgs, inst);
    }

    private static void checkAndApplyIBMLibertyProfileLogManagerWorkaround() {
        String javaClassPath;
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor != null && javaVendor.startsWith(IBM_VENDOR) && (javaClassPath = System.getProperty("java.class.path")) != null && javaClassPath.contains(WS_SERVER_JAR) && System.getProperty("java.util.logging.manager") == null) {
            try {
                Class.forName(WS_LOG_MANAGER, false, BootstrapAgent.class.getClassLoader());
                System.setProperty("java.util.logging.manager", WS_LOG_MANAGER);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void startAgent(String agentArgs, Instrumentation inst) {
        try {
            ClassLoader classLoader;
            long startTime = System.currentTimeMillis();
            BootstrapLoader.load(inst);
            boolean ibmWorkaround = IBMUtils.getIbmWorkaroundDefault();
            if (System.getProperty("ibm_iv25688_workaround") != null) {
                ibmWorkaround = Boolean.parseBoolean(System.getProperty("ibm_iv25688_workaround"));
            }
            if (ibmWorkaround) {
                classLoader = ClassLoader.getSystemClassLoader();
            } else {
                URL[] codeSource = new URL[]{BootstrapAgent.class.getProtectionDomain().getCodeSource().getLocation()};
                classLoader = new JVMAgentClassLoader(codeSource, null);
            }
            Class<?> agentClass = classLoader.loadClass(AGENT_CLASS_NAME);
            Method premain = agentClass.getDeclaredMethod("premain", String.class, Instrumentation.class, Long.TYPE);
            premain.invoke(null, agentArgs, inst, startTime);
        }
        catch (Throwable t) {
            System.err.println(MessageFormat.format("Error bootstrapping New Relic agent: {0}", t));
            t.printStackTrace();
        }
    }

    private static class JVMAgentClassLoader
    extends URLClassLoader {
        public JVMAgentClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        static {
            try {
                Method method = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
                method.setAccessible(true);
                method.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

