/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.sql;

import com.newrelic.agent.deps.com.google.common.cache.Cache;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.sql.CacheValue;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;

public class BoundedConcurrentCache<K, V extends Comparable<V> & CacheValue<K>> {
    private final int maxCapacity;
    private final PriorityBlockingQueue<V> priorityQueue;
    private final Cache<K, V> cache;

    public BoundedConcurrentCache(int size) {
        this(size, null);
    }

    public BoundedConcurrentCache(int size, Comparator<V> comparator) {
        this.maxCapacity = size;
        this.priorityQueue = new PriorityBlockingQueue<V>(size, comparator);
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(16).build();
    }

    public V get(K sql) {
        return (V)((Comparable)this.cache.getIfPresent(sql));
    }

    public V putIfAbsent(K key, V value) {
        Comparable putValue = (Comparable)this.cache.asMap().putIfAbsent(key, value);
        if (putValue != null) {
            return (V)putValue;
        }
        this.priorityQueue.add(value);
        while (this.priorityQueue.size() > this.maxCapacity) {
            Comparable val = (Comparable)this.priorityQueue.poll();
            Object sqlToRemove = ((CacheValue)((Object)val)).getKey();
            this.cache.invalidate(sqlToRemove);
        }
        return null;
    }

    public void putReplace(K key, V value) {
        Comparable valueToRemove = (Comparable)this.cache.getIfPresent(key);
        if (valueToRemove != null) {
            this.cache.invalidate(key);
            this.priorityQueue.remove(valueToRemove);
        }
        this.putIfAbsent(key, value);
    }

    public int size() {
        return this.priorityQueue.size();
    }

    public void clear() {
        this.cache.invalidateAll();
        this.priorityQueue.clear();
    }

    public List<V> asList() {
        return Lists.newArrayList(this.priorityQueue);
    }
}

