/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.attributes.AttributeSender;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.cache.CacheLoader;
import com.newrelic.agent.deps.com.google.common.cache.LoadingCache;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.AnalyticsEvent;
import com.newrelic.agent.service.analytics.CustomInsightsEvent;
import com.newrelic.agent.service.analytics.CustomInsightsEventsConfigUtils;
import com.newrelic.agent.service.analytics.InsightsService;
import com.newrelic.agent.service.analytics.ReservoirSampledArrayList;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.api.agent.Insights;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class InsightsServiceImpl
extends AbstractService
implements InsightsService {
    private final boolean enabled;
    private final ConcurrentMap<String, Boolean> isEnabledForApp = new ConcurrentHashMap<String, Boolean>();
    private final int maxSamplesStored;
    private final ConcurrentHashMap<String, ReservoirSampledArrayList<CustomInsightsEvent>> reservoirForApp = new ConcurrentHashMap();
    private static final LoadingCache<String, String> stringCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(70L, TimeUnit.SECONDS).build(new CacheLoader<String, String>(){

        @Override
        public String load(String key) throws Exception {
            return key;
        }
    });
    protected final HarvestListener harvestListener = new HarvestListener(){

        @Override
        public void beforeHarvest(String appName, StatsEngine statsEngine) {
            InsightsServiceImpl.this.harvest(appName, statsEngine);
        }

        @Override
        public void afterHarvest(String appName) {
        }
    };
    protected final TransactionListener transactionListener = new TransactionListener(){

        @Override
        public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
            TransactionInsights data = (TransactionInsights)transactionData.getInsightsData();
            InsightsServiceImpl.this.storeEvents(transactionData.getApplicationName(), data.events);
        }
    };
    protected final AgentConfigListener configListener = new AgentConfigListener(){

        @Override
        public void configChanged(String appName, AgentConfig agentConfig) {
            InsightsServiceImpl.this.isEnabledForApp.remove(appName);
        }
    };

    public InsightsServiceImpl() {
        super("Insights");
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.maxSamplesStored = CustomInsightsEventsConfigUtils.getMaxSamplesStored(config);
        this.enabled = CustomInsightsEventsConfigUtils.isCustomInsightsEventsEnabled(config, this.maxSamplesStored);
        this.isEnabledForApp.put(config.getApplicationName(), this.enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceFactory.getHarvestService().addHarvestListener(this.harvestListener);
        ServiceFactory.getTransactionService().addTransactionListener(this.transactionListener);
        ServiceFactory.getConfigService().addIAgentConfigListener(this.configListener);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getHarvestService().removeHarvestListener(this.harvestListener);
        ServiceFactory.getTransactionService().removeTransactionListener(this.transactionListener);
        ServiceFactory.getConfigService().removeIAgentConfigListener(this.configListener);
        this.reservoirForApp.clear();
        this.isEnabledForApp.clear();
        stringCache.invalidateAll();
    }

    public void recordCustomEvent(String eventType, Map<String, Object> attributes) {
        if (!this.enabled) {
            if (ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity()) {
                Agent.LOG.log(Level.FINER, "Event of type {0} not collected due to high security mode being enabled.", new Object[]{eventType});
            } else {
                Agent.LOG.log(Level.FINER, "Event of type {0} not collected. custom_insights_events not enabled.", new Object[]{eventType});
            }
            return;
        }
        if (AnalyticsEvent.isValidType(eventType)) {
            Transaction transaction = ServiceFactory.getTransactionService().getTransaction(false);
            if (transaction == null || !transaction.isInProgress()) {
                String applicationName = ServiceFactory.getRPMService().getApplicationName();
                AgentConfig agentConfig = ServiceFactory.getConfigService().getAgentConfig(applicationName);
                if (!this.getIsEnabledForApp(agentConfig, applicationName)) {
                    this.reservoirForApp.remove(applicationName);
                    return;
                }
                this.storeEvent(applicationName, eventType, attributes);
            } else {
                transaction.getInsightsData().recordCustomEvent(eventType, attributes);
            }
        } else {
            Agent.LOG.log(Level.WARNING, "Custom event with invalid type of {0} was reported but ignored. Event types must match /^[a-zA-Z0-9:_ ]+$/ and be less than 256 chars.", new Object[]{eventType});
        }
    }

    private void storeEvents(String appName, Collection<CustomInsightsEvent> events) {
        if (events.size() > 0) {
            ReservoirSampledArrayList<CustomInsightsEvent> eventList = this.getReservoir(appName);
            for (CustomInsightsEvent event : events) {
                Integer slot = eventList.getSlot();
                if (slot == null) continue;
                eventList.set(slot, event);
            }
        }
    }

    @Override
    public void storeEvent(String appName, CustomInsightsEvent event) {
        ReservoirSampledArrayList<CustomInsightsEvent> eventList = this.getReservoir(appName);
        Integer slot = eventList.getSlot();
        if (slot != null) {
            eventList.set(slot, event);
            Agent.LOG.finest(MessageFormat.format("Added Custom Event of type {0}", event.type));
        }
    }

    private void storeEvent(String appName, String eventType, Map<String, Object> attributes) {
        ReservoirSampledArrayList<CustomInsightsEvent> eventList = this.getReservoir(appName);
        Integer slot = eventList.getSlot();
        if (slot != null) {
            eventList.set(slot, InsightsServiceImpl.createValidatedEvent(eventType, attributes));
            Agent.LOG.finest(MessageFormat.format("Added Custom Event of type {0}", eventType));
        }
    }

    private ReservoirSampledArrayList<CustomInsightsEvent> getReservoir(String appName) {
        ReservoirSampledArrayList<CustomInsightsEvent> result = this.reservoirForApp.get(appName);
        while (result == null) {
            this.reservoirForApp.putIfAbsent(appName, new ReservoirSampledArrayList(this.maxSamplesStored));
            result = this.reservoirForApp.get(appName);
        }
        return result;
    }

    void harvest(String appName, StatsEngine statsEngine) {
        if (!this.getIsEnabledForApp(ServiceFactory.getConfigService().getAgentConfig(appName), appName)) {
            this.reservoirForApp.remove(appName);
            return;
        }
        ReservoirSampledArrayList reservoir = this.reservoirForApp.put(appName, new ReservoirSampledArrayList(this.maxSamplesStored));
        if (reservoir != null && reservoir.size() > 0) {
            try {
                ServiceFactory.getRPMService(appName).sendCustomAnalyticsEvents(this.maxSamplesStored, reservoir.getNumberOfTries(), Collections.unmodifiableList(reservoir));
                statsEngine.getStats("Supportability/Events/Customer/Sent").incrementCallCount(reservoir.size());
                statsEngine.getStats("Supportability/Events/Customer/Seen").incrementCallCount(reservoir.getNumberOfTries());
                if (reservoir.size() < reservoir.getNumberOfTries()) {
                    Agent.LOG.log(Level.WARNING, "Dropped {0} custom events out of {1}.", new Object[]{reservoir.getNumberOfTries() - reservoir.size(), reservoir.getNumberOfTries()});
                }
            }
            catch (Exception e) {
                Agent.LOG.fine("Unable to send custom events. Unsent events will be included in the next harvest.");
                ReservoirSampledArrayList<CustomInsightsEvent> currentReservoir = this.reservoirForApp.get(appName);
                currentReservoir.addAll(reservoir);
            }
        }
    }

    private boolean getIsEnabledForApp(AgentConfig config, String currentAppName) {
        Boolean appEnabled;
        Boolean bl = appEnabled = currentAppName == null ? null : (Boolean)this.isEnabledForApp.get(currentAppName);
        if (appEnabled == null) {
            appEnabled = CustomInsightsEventsConfigUtils.isCustomInsightsEventsEnabled(config, CustomInsightsEventsConfigUtils.getMaxSamplesStored(config));
            this.isEnabledForApp.put(currentAppName, appEnabled);
        }
        return appEnabled;
    }

    private static String mapInternString(String value) {
        try {
            return stringCache.get(value);
        }
        catch (ExecutionException e) {
            return value;
        }
    }

    private static CustomInsightsEvent createValidatedEvent(String eventType, Map<String, Object> attributes) {
        HashMap<String, Object> userAttributes = new HashMap<String, Object>(attributes.size());
        CustomInsightsEvent event = new CustomInsightsEvent(InsightsServiceImpl.mapInternString(eventType), System.currentTimeMillis(), userAttributes);
        CustomEventAttributeSender sender = new CustomEventAttributeSender(userAttributes);
        String method = "add custom event attribute";
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String key = InsightsServiceImpl.mapInternString(entry.getKey());
            Object value = entry.getValue();
            if (value instanceof String) {
                sender.addAttribute(key, InsightsServiceImpl.mapInternString((String)value), "add custom event attribute");
                continue;
            }
            if (value instanceof Number) {
                sender.addAttribute(key, (Number)value, "add custom event attribute");
                continue;
            }
            if (value instanceof Boolean) {
                sender.addAttribute(key, (Boolean)value, "add custom event attribute");
                continue;
            }
            sender.addAttribute(key, InsightsServiceImpl.mapInternString(value.toString()), "add custom event attribute");
        }
        return event;
    }

    @Override
    public Insights getTransactionInsights(AgentConfig config) {
        return new TransactionInsights(config);
    }

    public static final class TransactionInsights
    implements Insights {
        final LinkedBlockingQueue<CustomInsightsEvent> events;

        TransactionInsights(AgentConfig config) {
            int maxSamplesStored = CustomInsightsEventsConfigUtils.getMaxSamplesStored(config);
            this.events = new LinkedBlockingQueue(maxSamplesStored);
        }

        public void recordCustomEvent(String eventType, Map<String, Object> attributes) {
            if (ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity()) {
                Agent.LOG.log(Level.FINER, "Event of type {0} not collected due to high security mode being enabled.", new Object[]{eventType});
                return;
            }
            if (AnalyticsEvent.isValidType(eventType)) {
                CustomInsightsEvent event = InsightsServiceImpl.createValidatedEvent(eventType, attributes);
                if (this.events.offer(event)) {
                    Agent.LOG.finest(MessageFormat.format("Added Custom Event of type {0} in Transaction.", eventType));
                } else {
                    String applicationName = ServiceFactory.getRPMService().getApplicationName();
                    ServiceFactory.getServiceManager().getInsights().storeEvent(applicationName, event);
                }
            } else {
                Agent.LOG.log(Level.WARNING, "Custom event with invalid type of {0} was reported for a transaction but ignored. Event types must match /^[a-zA-Z0-9:_ ]+$/ and be less than 256 chars.", new Object[]{eventType});
            }
        }

        public List<CustomInsightsEvent> getEventsForTesting() {
            return new ArrayList<CustomInsightsEvent>(this.events);
        }
    }

    private static class CustomEventAttributeSender
    extends AttributeSender {
        private final Map<String, Object> userAttributes;

        public CustomEventAttributeSender(Map<String, Object> userAttributes) {
            this.userAttributes = userAttributes;
            this.setTransactional(false);
        }

        @Override
        protected String getAttributeType() {
            return ATTRIBUTE_TYPE;
        }

        @Override
        protected Map<String, Object> getAttributeMap() throws Throwable {
            return this.userAttributes;
        }
    }
}

