/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.v2;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.instrumentation.InstrumentedMethod;
import com.newrelic.agent.profile.method.ExactMethodInfo;
import com.newrelic.agent.profile.method.MethodInfo;
import com.newrelic.agent.profile.method.MethodInfoFactory;
import com.newrelic.agent.profile.v2.IProfile;
import com.newrelic.agent.profile.v2.ProfiledMethod;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ProfiledMethodFactory {
    private final ConcurrentMap<?, ProfiledMethod> profiledMethods = Maps.newConcurrentMap();
    private final ConcurrentMap<Object, Object> classFileNames = Maps.newConcurrentMap();
    private final IProfile profile;
    private final AtomicInteger nextMethodId = new AtomicInteger();
    private final ConcurrentMap<ClassMethodSignature, MethodInfo> methodInfos = Maps.newConcurrentMap();

    public ProfiledMethodFactory(IProfile profile) {
        this.profile = profile;
    }

    public ProfiledMethod getProfiledMethod(StackTraceElement stackTraceElement) {
        ProfiledMethod method = (ProfiledMethod)this.getStackTraceMethods().get(stackTraceElement);
        if (method == null && (method = ProfiledMethod.newProfiledMethod(this.getNextMethodId(), this.profile, stackTraceElement)) != null) {
            ProfiledMethod existing;
            if (stackTraceElement.getFileName() != null) {
                this.classFileNames.put(this.profile.getStringMap().addString(stackTraceElement.getClassName()), this.profile.getStringMap().addString(stackTraceElement.getFileName()));
            }
            if (null != (existing = this.getStackTraceMethods().putIfAbsent(stackTraceElement, method))) {
                return existing;
            }
        }
        return method;
    }

    private ConcurrentMap<StackTraceElement, ProfiledMethod> getStackTraceMethods() {
        return this.profiledMethods;
    }

    private ConcurrentMap<ClassMethodSignature, ProfiledMethod> getTracerMethods() {
        return this.profiledMethods;
    }

    public ProfiledMethod getProfiledMethod(Tracer tracer) {
        ClassMethodSignature methodSignature = tracer.getClassMethodSignature();
        ProfiledMethod method = (ProfiledMethod)this.getTracerMethods().get(methodSignature);
        if (method == null) {
            StackTraceElement stackTraceElement = new StackTraceElement(methodSignature.getClassName(), methodSignature.getMethodName(), null, -1);
            method = ProfiledMethod.newProfiledMethod(this.getNextMethodId(), this.profile, stackTraceElement);
            if (method != null) {
                ProfiledMethod previous = this.getTracerMethods().putIfAbsent(methodSignature, method);
                if (null != previous) {
                    method = previous;
                } else {
                    MethodInfo methodInfo = this.getMethodInfo(methodSignature);
                    method.setMethodInfo(methodInfo);
                }
            }
        }
        return method;
    }

    public MethodInfo getMethodInfo(ClassMethodSignature methodSignature) {
        MethodInfo methodInfo = (MethodInfo)this.methodInfos.get(methodSignature);
        if (null == methodInfo) {
            Type[] argumentTypes = Type.getArgumentTypes(methodSignature.getMethodDesc());
            ArrayList<String> arguments = Lists.newArrayListWithExpectedSize(argumentTypes.length);
            for (Type t : argumentTypes) {
                arguments.add(t.getClassName());
            }
            methodInfo = new ExactMethodInfo(arguments, (InstrumentedMethod)null);
            MethodInfo previous = this.methodInfos.putIfAbsent(methodSignature, methodInfo);
            if (previous != null) {
                return previous;
            }
        }
        return methodInfo;
    }

    private String getNextMethodId() {
        int id = this.nextMethodId.getAndIncrement();
        return Integer.toHexString(id);
    }

    public void setMethodDetails(MethodInfoFactory methodInfoFactory) {
        for (ProfiledMethod method : this.profiledMethods.values()) {
            method.setMethodDetails(methodInfoFactory);
        }
    }

    public Map<String, JSONStreamAware> getMethods() {
        HashMap<String, JSONStreamAware> map = Maps.newHashMap();
        for (ProfiledMethod method : this.profiledMethods.values()) {
            map.put(method.getMethodId(), method.getMethodJson());
        }
        return map;
    }

    public Map<Object, Object> getClasses() {
        return this.classFileNames;
    }
}

