/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.profile.method.MethodInfo;
import com.newrelic.agent.profile.method.MethodInfoUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;

public class ProfiledMethod
implements JSONStreamAware {
    private final StackTraceElement stackTraceElement;
    private final int hashCode;
    private MethodInfo info;

    private ProfiledMethod(StackTraceElement stackTraceElement) {
        this.stackTraceElement = stackTraceElement;
        this.hashCode = stackTraceElement.hashCode();
    }

    public static ProfiledMethod newProfiledMethod(StackTraceElement stackElement) {
        if (stackElement == null) {
            return null;
        }
        if (stackElement.getClassName() == null) {
            return null;
        }
        if (stackElement.getMethodName() == null) {
            return null;
        }
        return new ProfiledMethod(stackElement);
    }

    public String getFullMethodName() {
        return this.getClassName() + ":" + this.getMethodName();
    }

    public String getMethodName() {
        return this.stackTraceElement.getMethodName();
    }

    public String getClassName() {
        return this.stackTraceElement.getClassName();
    }

    public final int getLineNumber() {
        return this.stackTraceElement.getLineNumber();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProfiledMethod other = (ProfiledMethod)obj;
        return other.stackTraceElement.equals(this.stackTraceElement);
    }

    public String toString() {
        return this.getFullMethodName() + ":" + this.getLineNumber();
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        if (this.info == null) {
            JSONArray.writeJSONString(Arrays.asList(this.getClassName(), this.getMethodName(), this.getLineNumber()), out);
        } else {
            JSONArray.writeJSONString(Arrays.asList(this.getClassName(), this.getMethodName(), this.getLineNumber(), this.info.getJsonMethodMaps()), out);
        }
    }

    void setMethodDetails(Map<String, Class<?>> classMap) {
        Class<?> declaringClass = classMap.get(this.getClassName());
        if (declaringClass != null) {
            try {
                this.info = MethodInfoUtil.createMethodInfo(declaringClass, this.getMethodName(), this.getLineNumber());
            }
            catch (Throwable e) {
                Agent.LOG.log(Level.FINER, e, "Error finding MethodInfo for {0}.{1}", new Object[]{declaringClass.getName(), this.getMethodName()});
                this.info = null;
            }
        }
    }
}

