/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.methodmatchers;

import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.methodmatchers.InvalidMethodDescriptor;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class ExactMethodMatcher
implements MethodMatcher {
    private final String name;
    private final Set<String> descriptions;
    private final Method[] methods;

    public ExactMethodMatcher(String name, String description) {
        this(name, new String[]{description});
    }

    public ExactMethodMatcher(String name, Collection<String> descriptions) {
        this.name = name;
        if (descriptions.isEmpty()) {
            this.descriptions = Collections.emptySet();
            this.methods = null;
        } else {
            this.descriptions = Collections.unmodifiableSet(new HashSet<String>(descriptions));
            this.methods = new Method[descriptions.size()];
            String[] desc = descriptions.toArray(new String[0]);
            for (int i = 0; i < desc.length; ++i) {
                this.methods[i] = new Method(name, desc[i]);
            }
        }
    }

    public ExactMethodMatcher(String name, String ... descriptions) {
        this(name, Arrays.asList(descriptions));
    }

    String getName() {
        return this.name;
    }

    Set<String> getDescriptions() {
        return this.descriptions;
    }

    @Override
    public boolean matches(int access, String name, String desc, Set<String> annotations) {
        return this.name.equals(name) && (this.descriptions.isEmpty() || this.descriptions.contains(desc));
    }

    public String toString() {
        return "Match " + this.name + this.descriptions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.descriptions == null ? 0 : this.descriptions.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExactMethodMatcher other = (ExactMethodMatcher)obj;
        if (this.descriptions == null ? other.descriptions != null : !this.descriptions.equals(other.descriptions)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public void validate() throws InvalidMethodDescriptor {
        boolean valid = true;
        for (String methodDesc : this.descriptions) {
            try {
                Type[] types;
                for (Type t : types = Type.getArgumentTypes(methodDesc)) {
                    if (t != null) continue;
                    valid = false;
                    break;
                }
            }
            catch (Exception e) {
                valid = false;
            }
            if (valid) continue;
            throw new InvalidMethodDescriptor("Invalid method descriptor: " + methodDesc);
        }
    }

    @Override
    public Method[] getExactMethods() {
        return this.methods;
    }
}

