/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.context;

import com.newrelic.agent.Agent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.JSRInlinerAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.ClassNameFilter;
import com.newrelic.agent.instrumentation.InstrumentationType;
import com.newrelic.agent.instrumentation.InstrumentationUtils;
import com.newrelic.agent.instrumentation.InstrumentedClass;
import com.newrelic.agent.instrumentation.InstrumentedMethod;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.WeavedMethod;
import com.newrelic.agent.instrumentation.api.ApiImplementationUpdate;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.context.ClassChecker;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.ContextClassTransformer;
import com.newrelic.agent.instrumentation.context.CurrentTransactionRewriter;
import com.newrelic.agent.instrumentation.context.GeneratedClassDetector;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.context.TraceMatchVisitor;
import com.newrelic.agent.instrumentation.ejb3.EJBAnnotationVisitor;
import com.newrelic.agent.instrumentation.tracing.TraceClassTransformer;
import com.newrelic.agent.instrumentation.tracing.TraceDetails;
import com.newrelic.agent.instrumentation.weaver.ClassLoaderClassTransformer;
import com.newrelic.agent.instrumentation.weaver.ClassWeaverService;
import com.newrelic.agent.instrumentation.webservices.WebServiceVisitor;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.servlet.ServletAnnotationVisitor;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.util.asm.PatchedClassWriter;
import com.newrelic.agent.util.asm.Utils;
import com.newrelic.bootstrap.BootstrapLoader;
import com.newrelic.weave.utils.WeaveUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class InstrumentationContextManager {
    private static final Set<String> MARKER_INTERFACES_TO_SKIP = ImmutableSet.of("org/hibernate/proxy/HibernateProxy", "org/springframework/aop/SpringProxy", "java/security/PrivilegedAction");
    private static final Set<String> CLASSES_TO_SKIP_VERSION_UPGRADE = ImmutableSet.of("org/eclipse/core/runtime/internal/adaptor/ContextFinder");
    private static final ContextClassTransformer NO_OP_TRANSFORMER = new ContextClassTransformer(){

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, InstrumentationContext context, OptimizedClassMatcher.Match match) throws IllegalClassFormatException {
            return null;
        }
    };
    private final Map<ClassMatchVisitorFactory, ContextClassTransformer> matchVisitors = Maps.newConcurrentMap();
    private final Map<ClassMatchVisitorFactory, ContextClassTransformer> interfaceMatchVisitors = Maps.newConcurrentMap();
    private final Set<String> classloaderBlacklist;
    private final Instrumentation instrumentation;
    private ClassChecker classChecker;
    private final ClassWeaverService classWeaverService;
    private ClassFileTransformer jvmTransformer;
    private final ClassNameFilter classNameFilter;
    private static final Set<String> ANNOTATIONS_TO_REMOVE = ImmutableSet.of(Type.getDescriptor(InstrumentedClass.class), Type.getDescriptor(InstrumentedMethod.class), Type.getDescriptor(WeavedMethod.class));
    private final ContextClassTransformer FinishClassTransformer = new ContextClassTransformer(){

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, InstrumentationContext context, OptimizedClassMatcher.Match match) throws IllegalClassFormatException {
            try {
                if (!PointCutClassTransformer.isValidClassName(className)) {
                    return null;
                }
                return this.getFinalTransformation(loader, className, classBeingRedefined, classfileBuffer, context);
            }
            catch (Throwable ex) {
                Agent.LOG.log(Level.FINE, "Unable to transform " + className, ex);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getFinalTransformation(ClassLoader loader, String className, Class<?> classBeingRedefined, byte[] classfileBuffer, InstrumentationContext context) {
            PatchedClassWriter writer;
            ClassReader reader = new ClassReader(classfileBuffer);
            ClassVisitor cv = writer = new PatchedClassWriter(2, context.getClassResolver(loader));
            if (!context.getWeavedMethods().isEmpty()) {
                cv = new MarkWeaverMethodsVisitor(cv, context);
            }
            cv = InstrumentationContextManager.this.addModifiedClassAnnotation(cv, context);
            cv = InstrumentationContextManager.this.addModifiedMethodAnnotation(cv, context, loader);
            cv = new ClassVisitor(327680, cv){

                @Override
                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    if (version < 49 || version > 100) {
                        int newVersion = WeaveUtils.RUNTIME_MAX_SUPPORTED_CLASS_VERSION;
                        if (CLASSES_TO_SKIP_VERSION_UPGRADE.contains(name)) {
                            newVersion = 50;
                        }
                        Agent.LOG.log(Level.FINEST, "Converting {0} from version {1} to {2}", new Object[]{name, version, newVersion});
                        version = newVersion;
                    }
                    super.visit(version, access, name, signature, superName, interfaces);
                }

                @Override
                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    return new JSRInlinerAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc, signature, exceptions);
                }
            };
            cv = this.skipExistingAnnotations(cv);
            cv = CurrentTransactionRewriter.rewriteCurrentTransactionReferences(cv, reader, context);
            reader.accept(cv, 4);
            if (InstrumentationContextManager.this.classChecker != null) {
                InstrumentationContextManager.this.classChecker.check(writer.toByteArray());
            }
            if (Agent.isDebugEnabled()) {
                try {
                    File old = File.createTempFile(className.replace('/', '_'), ".old", BootstrapLoader.getTempDir());
                    Utils.print(context.bytes, new PrintWriter(old));
                    Agent.LOG.debug("Wrote " + old.getAbsolutePath());
                    File newFile = File.createTempFile(className.replace('/', '_'), ".new", BootstrapLoader.getTempDir());
                    Utils.print(writer.toByteArray(), new PrintWriter(newFile));
                    Agent.LOG.debug("Wrote " + newFile.getAbsolutePath());
                    File newClassFile = File.createTempFile(className.replace('/', '_'), ".new.class", BootstrapLoader.getTempDir());
                    FileOutputStream fos = new FileOutputStream(newClassFile);
                    try {
                        fos.write(writer.toByteArray());
                    }
                    finally {
                        fos.close();
                    }
                    Agent.LOG.debug("Wrote " + newClassFile.getAbsolutePath());
                }
                catch (Throwable t) {
                    Agent.LOG.log(Level.FINEST, t, "Error writing debug bytecode for {0}", new Object[]{className});
                }
            }
            this.addSupportabilityMetrics(reader, className, context);
            Agent.LOG.finer("Final transformation of class " + className);
            return writer.toByteArray();
        }

        private ClassVisitor skipExistingAnnotations(ClassVisitor cv) {
            return new ClassVisitor(327680, cv){

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    if (ANNOTATIONS_TO_REMOVE.contains(desc)) {
                        return null;
                    }
                    return super.visitAnnotation(desc, visible);
                }

                @Override
                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    return new MethodVisitor(327680, super.visitMethod(access, name, desc, signature, exceptions)){

                        @Override
                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            if (ANNOTATIONS_TO_REMOVE.contains(desc)) {
                                return null;
                            }
                            return super.visitAnnotation(desc, visible);
                        }
                    };
                }
            };
        }

        private void addSupportabilityMetrics(ClassReader reader, String className, InstrumentationContext context) {
            StatsService statsService = ServiceFactory.getStatsService();
            if (statsService != null) {
                for (Method m : context.getTimedMethods()) {
                    TraceDetails traceDetails = context.getTraceInformation().getTraceAnnotations().get(m);
                    if (traceDetails == null || !traceDetails.isCustom()) continue;
                    statsService.doStatsWork(StatsWorks.getRecordMetricWork(MessageFormat.format("Supportability/Instrumented/{0}/{1}{2}", className.replace('/', '.'), m.getName(), m.getDescriptor()), 1.0f));
                }
            }
        }
    };

    public InstrumentationContextManager(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        this.classWeaverService = new ClassWeaverService(this);
        this.matchVisitors.put(new TraceMatchVisitor(), NO_OP_TRANSFORMER);
        this.matchVisitors.put(new GeneratedClassDetector(), NO_OP_TRANSFORMER);
        AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        ClassTransformerConfig classTransformerConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getClassTransformerConfig();
        if (((Boolean)agentConfig.getValue("instrumentation.web_services.enabled", false)).booleanValue()) {
            Agent.LOG.log(Level.FINEST, "web_services instrumentation is enabled");
            this.matchVisitors.put(new WebServiceVisitor(), NO_OP_TRANSFORMER);
        } else if (!classTransformerConfig.isDefaultInstrumentationEnabled()) {
            Agent.LOG.log(Level.FINEST, "web_services instrumentation is disabled because it is not explicitly enabled");
        } else {
            this.matchVisitors.put(new WebServiceVisitor(), NO_OP_TRANSFORMER);
        }
        this.classNameFilter = new ClassNameFilter(Agent.LOG);
        this.classNameFilter.addConfigClassFilters(agentConfig);
        this.classNameFilter.addExcludeFileClassFilters();
        if (((Boolean)agentConfig.getValue("instrumentation.servlet_annotations.enabled", false)).booleanValue()) {
            Agent.LOG.log(Level.FINEST, "servlet_annotations instrumentation is enabled");
            this.matchVisitors.put(new ServletAnnotationVisitor(), NO_OP_TRANSFORMER);
        } else if (!classTransformerConfig.isDefaultInstrumentationEnabled()) {
            Agent.LOG.log(Level.FINEST, "servlet_annotations instrumentation is disabled because it is not explicitly enabled");
        } else {
            this.matchVisitors.put(new ServletAnnotationVisitor(), NO_OP_TRANSFORMER);
        }
        Config instrumentationConfig = agentConfig.getClassTransformerConfig().getInstrumentationConfig("com.newrelic.instrumentation.ejb-3.0");
        if (instrumentationConfig.getProperty("enabled", false).booleanValue()) {
            Agent.LOG.log(Level.FINEST, "ejb-3.0 instrumentation is enabled");
            this.matchVisitors.put(new EJBAnnotationVisitor(), NO_OP_TRANSFORMER);
        } else if (!classTransformerConfig.isDefaultInstrumentationEnabled()) {
            Agent.LOG.log(Level.FINEST, "ejb-3.0 instrumentation is disabled because it is not explicitly enabled");
        } else {
            this.matchVisitors.put(new EJBAnnotationVisitor(), NO_OP_TRANSFORMER);
        }
        this.classloaderBlacklist = agentConfig.getClassTransformerConfig().getClassloaderBlacklist();
        this.matchVisitors.put(ServiceFactory.getJarCollectorService().getSourceVisitor(), NO_OP_TRANSFORMER);
        try {
            ApiImplementationUpdate.setup(this);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e, e.toString(), new Object[0]);
        }
    }

    public ClassWeaverService getClassWeaverService() {
        return this.classWeaverService;
    }

    public static InstrumentationContextManager create(ClassLoaderClassTransformer classLoaderClassTransformer, InstrumentationProxy instrumentation, final boolean bootstrapClassloaderEnabled) throws Exception {
        final InstrumentationContextManager manager = new InstrumentationContextManager(instrumentation);
        final TraceClassTransformer traceTransformer = new TraceClassTransformer();
        manager.classWeaverService.registerInstrumentation();
        AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        final boolean defaultMethodTracingEnabled = agentConfig.getClassTransformerConfig().isDefaultMethodTracingEnabled();
        final boolean[] initialized = new boolean[]{false};
        ClassFileTransformer transformer = new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                try {
                    if (className == null) {
                        return null;
                    }
                    if (!initialized[0] && className.startsWith("com/newrelic/agent/")) {
                        return null;
                    }
                    if (loader == null && !bootstrapClassloaderEnabled) {
                        Agent.LOG.finest(MessageFormat.format("Instrumentation skipped by ''bootstrap'' rule: {0}", className));
                        return null;
                    }
                    if (!manager.shouldTransform(className, loader)) {
                        return null;
                    }
                    ClassReader reader = new ClassReader(classfileBuffer);
                    if (InstrumentationUtils.isAnnotation(reader)) {
                        return null;
                    }
                    if (InstrumentationUtils.isInterface(reader)) {
                        manager.applyInterfaceVisitors(loader, classBeingRedefined, reader);
                        if (!InstrumentationUtils.isDefaultMethodSupported(reader) || !defaultMethodTracingEnabled) {
                            return null;
                        }
                    }
                    if (Utils.isJdkProxy(reader)) {
                        Agent.LOG.finest(MessageFormat.format("Instrumentation skipped by ''JDK proxy'' rule: {0}", className));
                        return null;
                    }
                    InstrumentationContext context = new InstrumentationContext(classfileBuffer, classBeingRedefined, protectionDomain);
                    context.match(loader, classBeingRedefined, reader, manager.matchVisitors.keySet());
                    if (context.isGenerated()) {
                        if (context.hasSourceAttribute()) {
                            Agent.LOG.finest(MessageFormat.format("Instrumentation skipped by ''generated'' rule: {0}", className));
                        } else {
                            Agent.LOG.finest(MessageFormat.format("Instrumentation skipped by ''no source'' rule: {0}", className));
                        }
                        return null;
                    }
                    if (!context.getMatches().isEmpty() && InstrumentationContextManager.skipInterfaceMarkers(reader)) {
                        Agent.LOG.finest(MessageFormat.format("Instrumentation skipped by ''class name'' rule: {0}", className));
                        return null;
                    }
                    for (Map.Entry<ClassMatchVisitorFactory, OptimizedClassMatcher.Match> entry : context.getMatches().entrySet()) {
                        ContextClassTransformer transformer = (ContextClassTransformer)manager.matchVisitors.get(entry.getKey());
                        if (transformer != null && transformer != NO_OP_TRANSFORMER) {
                            byte[] bytes = transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer, context, entry.getValue());
                            classfileBuffer = context.processTransformBytes(classfileBuffer, bytes);
                            continue;
                        }
                        Agent.LOG.log(Level.FINE, "Unable to find a class transformer to process match {0}", new Object[]{entry.getValue()});
                    }
                    if (context.isTracerMatch()) {
                        byte[] bytes = traceTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer, context, null);
                        classfileBuffer = context.processTransformBytes(classfileBuffer, bytes);
                    }
                    if (context.isModified()) {
                        return manager.FinishClassTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer, context, null);
                    }
                }
                catch (Throwable t) {
                    Agent.LOG.log(Level.FINE, t, "Unexpected exception thrown in class transformer: {0}--{1}", new Object[]{loader, className});
                }
                return null;
            }
        };
        instrumentation.addTransformer(transformer, true);
        manager.jvmTransformer = transformer;
        manager.addContextClassTransformer(classLoaderClassTransformer, classLoaderClassTransformer);
        instrumentation.removeTransformer(classLoaderClassTransformer);
        manager.classWeaverService.createRetransformRunnable(instrumentation.getAllLoadedClasses()).run();
        initialized[0] = true;
        return manager;
    }

    private void applyInterfaceVisitors(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader) {
        ClassVisitor cv = null;
        for (ClassMatchVisitorFactory factory : this.interfaceMatchVisitors.keySet()) {
            cv = factory.newClassMatchVisitor(loader, classBeingRedefined, reader, cv, null);
        }
        if (cv != null) {
            reader.accept(cv, 1);
        }
    }

    private static boolean skipInterfaceMarkers(ClassReader reader) {
        for (String interfaceName : reader.getInterfaces()) {
            if (!MARKER_INTERFACES_TO_SKIP.contains(interfaceName)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldTransform(String internalClassName, ClassLoader classloader) {
        if (null == internalClassName) {
            return false;
        }
        if (this.isClassloaderBlacklisted(classloader)) {
            Agent.LOG.log(Level.FINEST, "Skipping transform of {0}. Classloader {1} is excluded.", new Object[]{internalClassName, classloader});
            return false;
        }
        if (internalClassName.startsWith("javax/crypto/")) {
            Agent.LOG.finest(MessageFormat.format("Instrumentation skipped by ''javax crypto'' rule: {0}", internalClassName));
            return false;
        }
        if (this.classNameFilter.isIncluded(internalClassName)) {
            Agent.LOG.log(Level.FINEST, "Class {0} is explicitly included", new Object[]{internalClassName});
            return true;
        }
        if (this.classNameFilter.isExcluded(internalClassName)) {
            Agent.LOG.log(Level.FINEST, "Skipping class {0} because it is excluded", new Object[]{internalClassName});
            return false;
        }
        return true;
    }

    public boolean isClassloaderBlacklisted(ClassLoader classloader) {
        String clName = null == classloader ? WeaveUtils.BOOTSTRAP_PLACEHOLDER.getClass().getName() : classloader.getClass().getName();
        for (String blacklistEntry : this.classloaderBlacklist) {
            if (!clName.startsWith(blacklistEntry)) continue;
            return true;
        }
        return false;
    }

    public void addContextClassTransformer(ClassMatchVisitorFactory matchVisitor, ContextClassTransformer transformer) {
        if (transformer == null) {
            transformer = NO_OP_TRANSFORMER;
        }
        this.matchVisitors.put(matchVisitor, transformer);
    }

    public void removeMatchVisitor(ClassMatchVisitorFactory visitor) {
        this.matchVisitors.remove(visitor);
    }

    protected ClassVisitor addModifiedMethodAnnotation(ClassVisitor cv, final InstrumentationContext context, final ClassLoader loader) {
        return new ClassVisitor(327680, cv){
            private String className;

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.className = name;
                super.visit(version, access, name, signature, superName, interfaces);
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                Method method = new Method(name, desc);
                if (context.isModified(method) && loader != null) {
                    Collection<String> instrumentationPackages;
                    PointCut pointCut;
                    TraceDetails traceDetails = context.getTraceInformation().getTraceAnnotations().get(method);
                    boolean dispatcher = false;
                    if (traceDetails != null) {
                        dispatcher = traceDetails.dispatcher();
                    }
                    AnnotationVisitor av = mv.visitAnnotation(Type.getDescriptor(InstrumentedMethod.class), true);
                    av.visit("dispatcher", dispatcher);
                    ArrayList<String> instrumentationNames = Lists.newArrayList();
                    ArrayList<InstrumentationType> instrumentationTypes = Lists.newArrayList();
                    Level logLevel = Level.FINER;
                    if (traceDetails != null) {
                        if (traceDetails.instrumentationSourceNames() != null) {
                            instrumentationNames.addAll(traceDetails.instrumentationSourceNames());
                        }
                        if (traceDetails.instrumentationTypes() != null) {
                            for (InstrumentationType type : traceDetails.instrumentationTypes()) {
                                instrumentationTypes.add(type);
                            }
                        }
                        if (traceDetails.isCustom()) {
                            logLevel = Level.FINE;
                        }
                    }
                    if ((pointCut = context.getOldStylePointCut(method)) != null) {
                        instrumentationNames.add(pointCut.getClass().getName());
                        instrumentationTypes.add(InstrumentationType.Pointcut);
                    }
                    if ((instrumentationPackages = context.getMergeInstrumentationPackages(method)) != null && !instrumentationPackages.isEmpty()) {
                        for (String string : instrumentationPackages) {
                            instrumentationNames.add(string);
                            instrumentationTypes.add(InstrumentationType.WeaveInstrumentation);
                        }
                    }
                    if (instrumentationNames.size() == 0) {
                        instrumentationNames.add("Unknown");
                        Agent.LOG.finest("Unknown instrumentation source for " + this.className + '.' + method);
                    }
                    if (instrumentationTypes.size() == 0) {
                        instrumentationTypes.add(InstrumentationType.Unknown);
                        Agent.LOG.finest("Unknown instrumentation type for " + this.className + '.' + method);
                    }
                    AnnotationVisitor visitArrayName = av.visitArray("instrumentationNames");
                    for (String string : instrumentationNames) {
                        visitArrayName.visit("", string);
                    }
                    visitArrayName.visitEnd();
                    AnnotationVisitor annotationVisitor = av.visitArray("instrumentationTypes");
                    for (InstrumentationType type : instrumentationTypes) {
                        annotationVisitor.visitEnum("", Type.getDescriptor(InstrumentationType.class), type.toString());
                    }
                    annotationVisitor.visitEnd();
                    av.visitEnd();
                    if (Agent.LOG.isLoggable(logLevel)) {
                        Agent.LOG.log(logLevel, "Instrumented " + Type.getObjectType(this.className).getClassName() + '.' + method + ", " + instrumentationTypes + ", " + instrumentationNames);
                    }
                }
                return mv;
            }
        };
    }

    protected ClassVisitor addModifiedClassAnnotation(ClassVisitor cv, InstrumentationContext context) {
        AnnotationVisitor visitAnnotation = cv.visitAnnotation(Type.getDescriptor(InstrumentedClass.class), true);
        if (context.isUsingLegacyInstrumentation()) {
            visitAnnotation.visit("legacy", Boolean.TRUE);
        }
        if (context.hasModifiedClassStructure()) {
            visitAnnotation.visit("classStructureModified", Boolean.TRUE);
        }
        visitAnnotation.visitEnd();
        return cv;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public ClassFileTransformer getJvmClassTransformer() {
        return this.jvmTransformer;
    }

    public void setClassChecker(ClassChecker classChecker) {
        this.classChecker = classChecker;
    }

    private static class MarkWeaverMethodsVisitor
    extends ClassVisitor {
        private final InstrumentationContext context;

        public MarkWeaverMethodsVisitor(ClassVisitor cv, InstrumentationContext context) {
            super(327680, cv);
            this.context = context;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            Collection<String> instrumentationTitles = this.context.getMergeInstrumentationPackages(new Method(name, desc));
            if (instrumentationTitles != null && !instrumentationTitles.isEmpty()) {
                AnnotationVisitor weavedAnnotation = mv.visitAnnotation(Type.getDescriptor(WeavedMethod.class), true);
                AnnotationVisitor visitArray = weavedAnnotation.visitArray("source");
                for (String title : instrumentationTitles) {
                    visitArray.visit("", title);
                }
                visitArray.visitEnd();
                weavedAnnotation.visitEnd();
            }
            return mv;
        }
    }
}

