/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.weave.utils.ClassFinder;
import com.newrelic.weave.utils.WeaveUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Map;
import java.util.logging.Level;

public class ClassLoaderClassFinder
implements ClassFinder {
    private final Map<String, byte[]> observedClassLoaders;

    public ClassLoaderClassFinder(Map<String, byte[]> observedClassLoaders) {
        this.observedClassLoaders = observedClassLoaders;
    }

    @Override
    public URL findResource(String internalName) {
        try {
            final byte[] classLoaderBytes = this.observedClassLoaders.get(WeaveUtils.getClassInternalName(internalName));
            if (classLoaderBytes != null) {
                return new URL(null, "classloader:" + internalName, new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL u) throws IOException {
                        return new URLConnection(u){

                            @Override
                            public void connect() throws IOException {
                            }

                            @Override
                            public InputStream getInputStream() throws IOException {
                                return new ByteArrayInputStream(classLoaderBytes);
                            }
                        };
                    }
                });
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, e, "Unable to load classloader bytes from memory", new Object[0]);
        }
        return null;
    }
}

