/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.install;

import com.newrelic.agent.install.SelfInstaller;
import com.newrelic.agent.util.EditableFile;

public class JBossSelfInstaller
extends SelfInstaller {
    private final String scriptPath = "/bin/run";
    private final String agentAlreadySet = "(.*)JAVA_OPTS=(.*)\\-javaagent:(.*)newrelic.jar";
    private final String windowsLocator = "set JBOSS_CLASSPATH=%RUN_CLASSPATH%";
    private String rootDir;

    @Override
    public boolean backupAndEditStartScript(String appServerRootDir) {
        this.rootDir = appServerRootDir;
        return this.backupAndEdit(appServerRootDir + this.getStartScript());
    }

    private boolean backupAndEdit(String fullPathToScript) {
        try {
            EditableFile file = new EditableFile(fullPathToScript);
            String fullSwitch = this.getCommentForAgentSwitch(file.comment) + lineSep + this.getAgentSettings();
            if (!file.contains(this.getAgentAlreadySetExpr())) {
                this.backup(file);
                if (this.osIsWindows) {
                    file.insertAfterLocator(this.getLocator(), lineSep + fullSwitch, true);
                } else {
                    file.append(fullSwitch + lineSep);
                }
                System.out.println("* Added agent switch to start script " + file.getLocation() + lineSep);
            } else {
                System.out.println("* Did not edit start script " + file.getLocation() + " because:");
                System.out.println("The agent switch is already set" + lineSep);
            }
            return true;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    @Override
    public String getStartScript() {
        String path = "/bin/run";
        if (this.osIsWindows) {
            path = path.replaceAll("/", "\\\\");
        }
        return path + (this.osIsWindows ? ".bat" : ".conf");
    }

    @Override
    public String getAlternateStartScript() {
        return this.getStartScript();
    }

    @Override
    public String getLocator() {
        return "set JBOSS_CLASSPATH=%RUN_CLASSPATH%";
    }

    @Override
    public String getAlternateLocator() {
        return this.getLocator();
    }

    @Override
    public String getAgentSettings() {
        String unixSwitch = "JAVA_OPTS=\"$JAVA_OPTS -javaagent:" + this.rootDir + "/newrelic/newrelic.jar\"" + lineSep;
        String windowsSwitch = "set JAVA_OPTS=-javaagent:\"" + this.rootDir.replaceAll("\\\\", "/") + "/newrelic/newrelic.jar\" %JAVA_OPTS%";
        return this.osIsWindows ? windowsSwitch : unixSwitch;
    }

    @Override
    public String getAgentAlreadySetExpr() {
        return "(.*)JAVA_OPTS=(.*)\\-javaagent:(.*)newrelic.jar";
    }
}

