/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.install;

import com.newrelic.agent.install.SelfInstaller;
import com.newrelic.agent.util.EditableFile;

public class GlassfishSelfInstaller
extends SelfInstaller {
    private final String scriptPath = "/config/domain.xml";
    private final String agentAlreadySet = "(.*)\\-javaagent:(.*)newrelic.jar(.*)";
    private final String locatorString = "(^.*java-config.*$)";

    @Override
    public boolean backupAndEditStartScript(String appServerRootDir) {
        return this.backupAndEdit(appServerRootDir + this.getStartScript());
    }

    private boolean backupAndEdit(String fullPathToScript) {
        try {
            EditableFile file = new EditableFile(fullPathToScript);
            if (!file.contains(this.getAgentAlreadySetExpr())) {
                this.backup(file);
                file.insertAfterLocator(this.getLocator(), this.getAgentSettings(), true);
                System.out.println("* Added agent switch to start script " + file.getLocation() + lineSep);
            } else {
                System.out.println("* Did not edit start script " + file.getLocation() + " because:");
                System.out.println("The agent switch is already set" + lineSep);
            }
            return true;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    @Override
    public String getStartScript() {
        return "/config/domain.xml";
    }

    @Override
    public String getAlternateStartScript() {
        return this.getStartScript();
    }

    @Override
    public String getLocator() {
        return "(^.*java-config.*$)";
    }

    @Override
    public String getAlternateLocator() {
        return this.getLocator();
    }

    @Override
    public String getAgentSettings() {
        return "        <jvm-options>-javaagent:\\${com.sun.aas.instanceRoot}/newrelic/newrelic.jar</jvm-options>";
    }

    @Override
    public String getAgentAlreadySetExpr() {
        return "(.*)\\-javaagent:(.*)newrelic.jar(.*)";
    }
}

