/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension.jaxb;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.extension.jaxb.UnmarshalException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class Unmarshaller<T> {
    private static final Map<Class<?>, Unmarshaller<?>> DEFAULT_UNMARSHALLERS = Unmarshaller.createDefaultUnmarshallers();
    private final Class<?> type;

    public Unmarshaller(Class<?> type) {
        this.type = type;
    }

    public abstract T unmarshall(Node var1) throws UnmarshalException;

    public String toString() {
        return "Unmarshaller [type=" + this.type + "]";
    }

    private static Map<Class<?>, Unmarshaller<?>> createDefaultUnmarshallers() {
        HashMap<Class<Integer>, Unmarshaller> unmarshallers = Maps.newHashMap();
        unmarshallers.put(String.class, new Unmarshaller<String>(String.class){

            @Override
            public String unmarshall(Node node) {
                if (node.getNodeType() == 1) {
                    Node firstChild = node.getFirstChild();
                    if (firstChild == null) {
                        throw new DOMException(8, MessageFormat.format("The element node {0}  is present, but is empty.", node.getNodeName()));
                    }
                    return node.getFirstChild().getNodeValue();
                }
                return node.getNodeValue();
            }
        });
        unmarshallers.put(Boolean.class, new Unmarshaller<Boolean>(Boolean.class){

            @Override
            public Boolean unmarshall(Node node) {
                return Boolean.valueOf(node.getNodeValue());
            }
        });
        unmarshallers.put(Double.class, new Unmarshaller<Double>(Double.class){

            @Override
            public Double unmarshall(Node node) {
                return Double.valueOf(node.getNodeValue());
            }
        });
        unmarshallers.put(Long.class, new Unmarshaller<Long>(Long.class){

            @Override
            public Long unmarshall(Node node) {
                return Long.valueOf(node.getNodeValue());
            }
        });
        unmarshallers.put(Integer.class, new Unmarshaller<Integer>(Integer.class){

            @Override
            public Integer unmarshall(Node node) {
                return Integer.valueOf(node.getNodeValue());
            }
        });
        return ImmutableMap.copyOf(unmarshallers);
    }

    public static Map<? extends Class<?>, ? extends Unmarshaller<?>> getDefaultUnmarshallers() {
        return DEFAULT_UNMARSHALLERS;
    }
}

