/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.org.yaml.snakeyaml.constructor;

import com.newrelic.agent.deps.org.yaml.snakeyaml.constructor.BaseConstructor;
import com.newrelic.agent.deps.org.yaml.snakeyaml.constructor.Construct;
import com.newrelic.agent.deps.org.yaml.snakeyaml.constructor.ConstructorException;
import com.newrelic.agent.deps.org.yaml.snakeyaml.error.YAMLException;
import com.newrelic.agent.deps.org.yaml.snakeyaml.nodes.MappingNode;
import com.newrelic.agent.deps.org.yaml.snakeyaml.nodes.Node;
import com.newrelic.agent.deps.org.yaml.snakeyaml.nodes.ScalarNode;
import com.newrelic.agent.deps.org.yaml.snakeyaml.nodes.SequenceNode;
import com.newrelic.agent.deps.org.yaml.snakeyaml.util.Base64Coder;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeConstructor
extends BaseConstructor {
    private static final Map<String, Boolean> BOOL_VALUES = new HashMap<String, Boolean>();
    private static final Pattern TIMESTAMP_REGEXP;
    private static final Pattern YMD_REGEXP;

    public SafeConstructor() {
        this.yamlConstructors.put("tag:yaml.org,2002:null", new ConstuctYamlNull());
        this.yamlConstructors.put("tag:yaml.org,2002:bool", new ConstuctYamlBool());
        this.yamlConstructors.put("tag:yaml.org,2002:int", new ConstuctYamlInt());
        this.yamlConstructors.put("tag:yaml.org,2002:float", new ConstuctYamlFloat());
        this.yamlConstructors.put("tag:yaml.org,2002:binary", new ConstuctYamlBinary());
        this.yamlConstructors.put("tag:yaml.org,2002:timestamp", new ConstuctYamlTimestamp());
        this.yamlConstructors.put("tag:yaml.org,2002:omap", new ConstuctYamlOmap());
        this.yamlConstructors.put("tag:yaml.org,2002:pairs", new ConstuctYamlPairs());
        this.yamlConstructors.put("tag:yaml.org,2002:set", new ConstuctYamlSet());
        this.yamlConstructors.put("tag:yaml.org,2002:str", new ConstuctYamlStr());
        this.yamlConstructors.put("tag:yaml.org,2002:seq", new ConstuctYamlSeq());
        this.yamlConstructors.put("tag:yaml.org,2002:map", new ConstuctYamlMap());
        this.yamlConstructors.put(null, new ConstuctUndefined());
    }

    private void flattenMapping(MappingNode node) {
        LinkedList<Node[]> merge = new LinkedList<Node[]>();
        int index = 0;
        Object nodeValue = node.getValue();
        block4: while (index < nodeValue.size()) {
            Node keyNode = ((Node[])nodeValue.get(index))[0];
            Node valueNode = ((Node[])nodeValue.get(index))[1];
            if (keyNode.getTag().equals("tag:yaml.org,2002:merge")) {
                nodeValue.remove(index);
                switch (valueNode.getNodeId()) {
                    case mapping: {
                        MappingNode mn = (MappingNode)valueNode;
                        this.flattenMapping(mn);
                        merge.addAll((Collection<Node[]>)mn.getValue());
                        break;
                    }
                    case sequence: {
                        LinkedList<Object> submerge = new LinkedList<Object>();
                        SequenceNode sn = (SequenceNode)valueNode;
                        Object vals = sn.getValue();
                        Iterator i$ = vals.iterator();
                        while (i$.hasNext()) {
                            Node node2 = (Node)i$.next();
                            if (!(node2 instanceof MappingNode)) {
                                throw new ConstructorException("while constructing a mapping", node.getStartMark(), "expected a mapping for merging, but found " + (Object)((Object)node2.getNodeId()), node2.getStartMark());
                            }
                            MappingNode mnode = (MappingNode)node2;
                            this.flattenMapping(mnode);
                            submerge.add(mnode.getValue());
                        }
                        Collections.reverse(submerge);
                        for (List list : submerge) {
                            merge.addAll(list);
                        }
                        continue block4;
                    }
                    default: {
                        throw new ConstructorException("while constructing a mapping", node.getStartMark(), "expected a mapping or list of mappings for merging, but found " + (Object)((Object)valueNode.getNodeId()), valueNode.getStartMark());
                    }
                }
                continue;
            }
            if (keyNode.getTag().equals("tag:yaml.org,2002:value")) {
                keyNode.setTag("tag:yaml.org,2002:str");
                ++index;
                continue;
            }
            ++index;
        }
        if (!merge.isEmpty()) {
            merge.addAll((Collection<Node[]>)nodeValue);
            node.setValue(merge);
        }
    }

    @Override
    protected Map<Object, Object> constructMapping(MappingNode node) {
        this.flattenMapping(node);
        return super.constructMapping(node);
    }

    private Number createNumber(int sign, String number, int radix) {
        Number result;
        if (sign < 0) {
            number = "-" + number;
        }
        try {
            int integer = Integer.parseInt(number, radix);
            result = new Integer(integer);
        }
        catch (NumberFormatException e) {
            try {
                long longValue = Long.parseLong(number, radix);
                result = new Long(longValue);
            }
            catch (NumberFormatException e1) {
                result = new BigInteger(number, radix);
            }
        }
        return result;
    }

    static {
        BOOL_VALUES.put("yes", Boolean.TRUE);
        BOOL_VALUES.put("no", Boolean.FALSE);
        BOOL_VALUES.put("true", Boolean.TRUE);
        BOOL_VALUES.put("false", Boolean.FALSE);
        BOOL_VALUES.put("on", Boolean.TRUE);
        BOOL_VALUES.put("off", Boolean.FALSE);
        TIMESTAMP_REGEXP = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:(?:[Tt]|[ \t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \t]*(?:Z|([-+][0-9][0-9]?)(?::([0-9][0-9])?)?))?)?$");
        YMD_REGEXP = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)$");
    }

    private class ConstuctUndefined
    implements Construct {
        private ConstuctUndefined() {
        }

        public Object construct(Node node) {
            throw new ConstructorException(null, null, "could not determine a constructor for the tag " + node.getTag(), node.getStartMark());
        }
    }

    private class ConstuctYamlMap
    implements Construct {
        private ConstuctYamlMap() {
        }

        public Object construct(Node node) {
            return SafeConstructor.this.constructMapping((MappingNode)node);
        }
    }

    private class ConstuctYamlSeq
    implements Construct {
        private ConstuctYamlSeq() {
        }

        public Object construct(Node node) {
            return SafeConstructor.this.constructSequence((SequenceNode)node);
        }
    }

    private class ConstuctYamlStr
    implements Construct {
        private ConstuctYamlStr() {
        }

        public Object construct(Node node) {
            String value = (String)SafeConstructor.this.constructScalar((ScalarNode)node);
            return value;
        }
    }

    private class ConstuctYamlSet
    implements Construct {
        private ConstuctYamlSet() {
        }

        public Object construct(Node node) {
            Map<Object, Object> value = SafeConstructor.this.constructMapping((MappingNode)node);
            return value.keySet();
        }
    }

    private class ConstuctYamlPairs
    implements Construct {
        private ConstuctYamlPairs() {
        }

        public Object construct(Node node) {
            LinkedList<Object[]> pairs = new LinkedList<Object[]>();
            if (!(node instanceof SequenceNode)) {
                throw new ConstructorException("while constructing pairs", node.getStartMark(), "expected a sequence, but found " + (Object)((Object)node.getNodeId()), node.getStartMark());
            }
            SequenceNode snode = (SequenceNode)node;
            Iterator i$ = snode.getValue().iterator();
            while (i$.hasNext()) {
                Node subnode = (Node)i$.next();
                if (!(subnode instanceof MappingNode)) {
                    throw new ConstructorException("while constructingpairs", node.getStartMark(), "expected a mapping of length 1, but found " + (Object)((Object)subnode.getNodeId()), subnode.getStartMark());
                }
                MappingNode mnode = (MappingNode)subnode;
                if (mnode.getValue().size() != 1) {
                    throw new ConstructorException("while constructing pairs", node.getStartMark(), "expected a single mapping item, but found " + mnode.getValue().size() + " items", mnode.getStartMark());
                }
                Node keyNode = ((Node[])mnode.getValue().get(0))[0];
                Node valueNode = ((Node[])mnode.getValue().get(0))[1];
                Object key = SafeConstructor.this.constructObject(keyNode);
                Object value = SafeConstructor.this.constructObject(valueNode);
                pairs.add(new Object[]{key, value});
            }
            return pairs;
        }
    }

    private class ConstuctYamlOmap
    implements Construct {
        private ConstuctYamlOmap() {
        }

        public Object construct(Node node) {
            LinkedHashMap<Object, Object> omap = new LinkedHashMap<Object, Object>();
            if (!(node instanceof SequenceNode)) {
                throw new ConstructorException("while constructing an ordered map", node.getStartMark(), "expected a sequence, but found " + (Object)((Object)node.getNodeId()), node.getStartMark());
            }
            SequenceNode snode = (SequenceNode)node;
            Iterator i$ = snode.getValue().iterator();
            while (i$.hasNext()) {
                Node subnode = (Node)i$.next();
                if (!(subnode instanceof MappingNode)) {
                    throw new ConstructorException("while constructing an ordered map", node.getStartMark(), "expected a mapping of length 1, but found " + (Object)((Object)subnode.getNodeId()), subnode.getStartMark());
                }
                MappingNode mnode = (MappingNode)subnode;
                if (mnode.getValue().size() != 1) {
                    throw new ConstructorException("while constructing an ordered map", node.getStartMark(), "expected a single mapping item, but found " + mnode.getValue().size() + " items", mnode.getStartMark());
                }
                Node keyNode = ((Node[])mnode.getValue().get(0))[0];
                Node valueNode = ((Node[])mnode.getValue().get(0))[1];
                Object key = SafeConstructor.this.constructObject(keyNode);
                Object value = SafeConstructor.this.constructObject(valueNode);
                omap.put(key, value);
            }
            return omap;
        }
    }

    private class ConstuctYamlTimestamp
    implements Construct {
        private ConstuctYamlTimestamp() {
        }

        public Object construct(Node node) {
            Matcher match = YMD_REGEXP.matcher((String)node.getValue());
            if (match.matches()) {
                String year_s = match.group(1);
                String month_s = match.group(2);
                String day_s = match.group(3);
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                cal.clear();
                cal.set(1, Integer.parseInt(year_s));
                cal.set(2, Integer.parseInt(month_s) - 1);
                cal.set(5, Integer.parseInt(day_s));
                return cal.getTime();
            }
            match = TIMESTAMP_REGEXP.matcher((String)node.getValue());
            if (!match.matches()) {
                throw new YAMLException("Expected timestamp: " + node);
            }
            String year_s = match.group(1);
            String month_s = match.group(2);
            String day_s = match.group(3);
            String hour_s = match.group(4);
            String min_s = match.group(5);
            String sec_s = match.group(6);
            String fract_s = match.group(7);
            String timezoneh_s = match.group(8);
            String timezonem_s = match.group(9);
            int usec = 0;
            if (fract_s != null && (usec = Integer.parseInt(fract_s)) != 0) {
                while (10 * usec < 1000) {
                    usec *= 10;
                }
            }
            Calendar cal = Calendar.getInstance();
            cal.set(1, Integer.parseInt(year_s));
            cal.set(2, Integer.parseInt(month_s) - 1);
            cal.set(5, Integer.parseInt(day_s));
            cal.set(11, Integer.parseInt(hour_s));
            cal.set(12, Integer.parseInt(min_s));
            cal.set(13, Integer.parseInt(sec_s));
            cal.set(14, usec);
            if (timezoneh_s != null || timezonem_s != null) {
                int zone = 0;
                int sign = 1;
                if (timezoneh_s != null) {
                    if (timezoneh_s.startsWith("-")) {
                        sign = -1;
                    }
                    zone += Integer.parseInt(timezoneh_s.substring(1)) * 3600000;
                }
                if (timezonem_s != null) {
                    zone += Integer.parseInt(timezonem_s) * 60000;
                }
                cal.set(15, sign * zone);
            } else {
                cal.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
            return cal.getTime();
        }
    }

    private class ConstuctYamlBinary
    implements Construct {
        private ConstuctYamlBinary() {
        }

        public Object construct(Node node) {
            byte[] decoded = Base64Coder.decode(SafeConstructor.this.constructScalar((ScalarNode)node).toString().toCharArray());
            return decoded;
        }
    }

    private class ConstuctYamlFloat
    implements Construct {
        private ConstuctYamlFloat() {
        }

        public Object construct(Node node) {
            String value = SafeConstructor.this.constructScalar((ScalarNode)node).toString().replaceAll("_", "");
            int sign = 1;
            char first = value.charAt(0);
            if (first == '-') {
                sign = -1;
                value = value.substring(1);
            } else if (first == '+') {
                value = value.substring(1);
            }
            String valLower = value.toLowerCase();
            if (valLower.equals(".inf")) {
                return new Double(sign == -1 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
            if (valLower.equals(".nan")) {
                return new Double(Double.NaN);
            }
            if (value.indexOf(58) != -1) {
                String[] digits = value.split(":");
                int bes = 1;
                double val = 0.0;
                int j = digits.length;
                for (int i = 0; i < j; ++i) {
                    val += Double.parseDouble(digits[j - i - 1]) * (double)bes;
                    bes *= 60;
                }
                return new Double((double)sign * val);
            }
            try {
                Double d = Double.valueOf(value);
                return new Double(d * (double)sign);
            }
            catch (NumberFormatException e) {
                throw new YAMLException("Invalid number: '" + value + "'; in node " + node);
            }
        }
    }

    private class ConstuctYamlInt
    implements Construct {
        private ConstuctYamlInt() {
        }

        public Object construct(Node node) {
            String value = SafeConstructor.this.constructScalar((ScalarNode)node).toString().replaceAll("_", "");
            int sign = 1;
            char first = value.charAt(0);
            if (first == '-') {
                sign = -1;
                value = value.substring(1);
            } else if (first == '+') {
                value = value.substring(1);
            }
            int base = 10;
            if (value.equals("0")) {
                return new Integer(0);
            }
            if (value.startsWith("0b")) {
                value = value.substring(2);
                base = 2;
            } else if (value.startsWith("0x")) {
                value = value.substring(2);
                base = 16;
            } else if (value.startsWith("0")) {
                value = value.substring(1);
                base = 8;
            } else {
                if (value.indexOf(58) != -1) {
                    String[] digits = value.split(":");
                    int bes = 1;
                    int val = 0;
                    int j = digits.length;
                    for (int i = 0; i < j; ++i) {
                        val = (int)((long)val + Long.parseLong(digits[j - i - 1]) * (long)bes);
                        bes *= 60;
                    }
                    return SafeConstructor.this.createNumber(sign, String.valueOf(val), 10);
                }
                return SafeConstructor.this.createNumber(sign, value, 10);
            }
            return SafeConstructor.this.createNumber(sign, value, base);
        }
    }

    private class ConstuctYamlBool
    implements Construct {
        private ConstuctYamlBool() {
        }

        public Object construct(Node node) {
            String val = (String)SafeConstructor.this.constructScalar((ScalarNode)node);
            return BOOL_VALUES.get(val.toLowerCase());
        }
    }

    private class ConstuctYamlNull
    implements Construct {
        private ConstuctYamlNull() {
        }

        public Object construct(Node node) {
            SafeConstructor.this.constructScalar((ScalarNode)node);
            return null;
        }
    }
}

