/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.ch.qos.logback.core.rolling.helper;

import com.newrelic.agent.deps.ch.qos.logback.core.rolling.RollingFileAppender;
import com.newrelic.agent.deps.ch.qos.logback.core.rolling.RolloverFailure;
import com.newrelic.agent.deps.ch.qos.logback.core.spi.ContextAwareBase;
import com.newrelic.agent.deps.ch.qos.logback.core.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class RenameUtil
extends ContextAwareBase {
    static String RENAMING_ERROR_URL = "http://logback.qos.ch/codes.html#renamingError";
    static final int BUF_SIZE = 32768;

    public void rename(String from, String to) throws RolloverFailure {
        if (from.equals(to)) {
            this.addWarn("From and to file are the same [" + from + "]. Skipping.");
            return;
        }
        File fromFile = new File(from);
        if (fromFile.exists()) {
            File toFile = new File(to);
            this.createMissingTargetDirsIfNecessary(toFile);
            this.addInfo("Renaming file [" + fromFile + "] to [" + toFile + "]");
            boolean result = fromFile.renameTo(toFile);
            if (!result) {
                this.addWarn("Failed to rename file [" + fromFile + "] to [" + toFile + "].");
                this.addWarn("Please consider leaving the [file] option of " + RollingFileAppender.class.getSimpleName() + " empty.");
                this.addWarn("See also " + RENAMING_ERROR_URL);
            }
        } else {
            throw new RolloverFailure("File [" + from + "] does not exist.");
        }
    }

    public void renameByCopying(String from, String to) throws RolloverFailure {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int n;
            bis = new BufferedInputStream(new FileInputStream(from));
            bos = new BufferedOutputStream(new FileOutputStream(to));
            byte[] inbuf = new byte[32768];
            while ((n = bis.read(inbuf)) != -1) {
                ((BufferedOutputStream)bos).write(inbuf, 0, n);
            }
            bis.close();
            bis = null;
            bos.close();
            bos = null;
            File fromFile = new File(from);
            if (!fromFile.delete()) {
                this.addWarn("Could not delete " + from);
            }
        }
        catch (IOException ioe) {
            this.addError("Failed to rename file by copying", ioe);
            throw new RolloverFailure("Failed to rename file by copying");
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    void createMissingTargetDirsIfNecessary(File toFile) throws RolloverFailure {
        boolean result;
        if (FileUtil.isParentDirectoryCreationRequired(toFile) && !(result = FileUtil.createMissingParentDirectories(toFile))) {
            throw new RolloverFailure("Failed to create parent directories for [" + toFile.getAbsolutePath() + "]");
        }
    }

    public String toString() {
        return "c.q.l.co.rolling.helper.RenameUtil";
    }
}

