/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.datastore;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.Hostname;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.api.agent.TracedMethod;
import java.text.MessageFormat;

public class DatastoreMetrics {
    public static final String METRIC_NAMESPACE = "Datastore";
    public static final String ALL = "Datastore/all";
    public static final String ALL_WEB = "Datastore/allWeb";
    public static final String ALL_OTHER = "Datastore/allOther";
    public static final String VENDOR_ALL = "Datastore/{0}/all";
    public static final String VENDOR_ALL_WEB = "Datastore/{0}/allWeb";
    public static final String VENDOR_ALL_OTHER = "Datastore/{0}/allOther";
    public static final String STATEMENT_METRIC = "Datastore/statement/{0}/{1}/{2}";
    public static final String OPERATION_METRIC = "Datastore/operation/{0}/{1}";
    public static final String INSTANCE_METRIC_BASE = "Datastore/instance/{0}/";
    public static final String INSTANCE_ID = "{0}/{1}";
    public static final String DEFAULT_OPERATION = "other";
    public static final String DEFAULT_TABLE = "other";
    public static final String INSTANCE_ATTRIBUTE = "instance";
    public static final String INPUT_QUERY_ATTRIBUTE = "input_query";
    public static final String INPUT_QUERY_LABEL_PARAMETER = "label";
    public static final String INPUT_QUERY_QUERY_PARAMETER = "query";
    public static final String DATASTORE_HOST = "host";
    public static final String DATASTORE_PORT_PATH_OR_ID = "port_path_or_id";
    public static final String DATASTORE_DATABASENAME = "database_name";
    public static String HOSTNAME = Hostname.getHostname(ServiceFactory.getConfigService().getDefaultAgentConfig());
    public static final String UNKNOWN = "unknown";

    public static void collectDatastoreMetrics(String datastoreVendor, Transaction tx, TracedMethod method, String table, String operation, String host, Integer port, String identifier, String databaseName) {
        boolean allUnknown;
        if (null == table) {
            method.setMetricName(new String[]{MessageFormat.format(OPERATION_METRIC, datastoreVendor, operation)});
        } else {
            method.addRollupMetricName(new String[]{MessageFormat.format(OPERATION_METRIC, datastoreVendor, operation)});
            method.setMetricName(new String[]{MessageFormat.format(STATEMENT_METRIC, datastoreVendor, table, operation)});
        }
        DatastoreMetrics.recordDatastoreSupportabilityMetrics(datastoreVendor, host, port, identifier, databaseName);
        boolean bl = allUnknown = host == null && port == null && identifier == null;
        if (ServiceFactory.getConfigService().getDefaultAgentConfig().getDatastoreConfig().isInstanceReportingEnabled() && !allUnknown) {
            method.addRollupMetricName(new String[]{DatastoreMetrics.buildInstanceMetric(datastoreVendor, host, port, identifier)});
        }
        method.addRollupMetricName(new String[]{ALL});
        method.addRollupMetricName(new String[]{MessageFormat.format(VENDOR_ALL, datastoreVendor)});
        if (tx.isWebTransaction()) {
            method.addRollupMetricName(new String[]{ALL_WEB});
            method.addRollupMetricName(new String[]{MessageFormat.format(VENDOR_ALL_WEB, datastoreVendor)});
        } else {
            method.addRollupMetricName(new String[]{ALL_OTHER});
            method.addRollupMetricName(new String[]{MessageFormat.format(VENDOR_ALL_OTHER, datastoreVendor)});
        }
    }

    private static void recordDatastoreSupportabilityMetrics(String vendor, String host, Integer port, String identifier, String databaseName) {
        StatsService statsService = ServiceFactory.getStatsService();
        if (host == null) {
            String unknownHostMetric = MessageFormat.format("Supportability/Datastore/{0}/unknownHost", vendor);
            statsService.doStatsWork(StatsWorks.getIncrementCounterWork(unknownHostMetric, 1));
        }
        if (port == null && identifier == null) {
            String unknownPortMetric = MessageFormat.format("Supportability/Datastore/{0}/unknownPort", vendor);
            statsService.doStatsWork(StatsWorks.getIncrementCounterWork(unknownPortMetric, 1));
        }
        if (databaseName == null) {
            String unknownDatabaseNameMetric = MessageFormat.format("Supportability/Datastore/{0}/unknownDatabaseName", vendor);
            statsService.doStatsWork(StatsWorks.getIncrementCounterWork(unknownDatabaseNameMetric, 1));
        }
    }

    public static String replaceIdentifier(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            return UNKNOWN;
        }
        return identifier;
    }

    public static String replacePort(Integer port) {
        if (port == null || port == -1) {
            return UNKNOWN;
        }
        return String.valueOf(port);
    }

    public static String replaceLocalhost(String host) {
        if (host == null || host.isEmpty()) {
            return UNKNOWN;
        }
        if ("localhost".equals(host) || "127.0.0.1".equals(host) || "0.0.0.0".equals(host) || "0:0:0:0:0:0:0:1".equals(host) || "::1".equals(host) || "0:0:0:0:0:0:0:0".equals(host) || "::".equals(host)) {
            return HOSTNAME;
        }
        return host;
    }

    public static void unparsedQuerySupportability(String datastoreVendor) {
        NewRelic.incrementCounter((String)MessageFormat.format("Supportability/Datastore/{0}/unparsedQuery", datastoreVendor));
    }

    public static String buildInstanceIdentifier(String host, Integer port, String id) {
        String hostname = DatastoreMetrics.replaceLocalhost(host);
        String identifier = null;
        if (id != null) {
            identifier = DatastoreMetrics.replaceIdentifier(id);
            if (host == null || host.isEmpty()) {
                hostname = HOSTNAME;
            }
        } else {
            identifier = DatastoreMetrics.replacePort(port);
        }
        return MessageFormat.format(INSTANCE_ID, hostname, identifier);
    }

    public static String buildInstanceMetric(String dbVendor, String host, Integer port, String id) {
        String instanceId = DatastoreMetrics.buildInstanceIdentifier(host, port, id);
        return MessageFormat.format(INSTANCE_METRIC_BASE, dbVendor) + instanceId;
    }

    public static void setHostname(String hostname) {
        HOSTNAME = hostname;
    }

    public static String getIdentifierOrPort(Integer port, String identifier) {
        if (identifier != null) {
            return DatastoreMetrics.replaceIdentifier(identifier);
        }
        return DatastoreMetrics.replacePort(port);
    }
}

