/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class SystemPropertyProvider {
    private static final String HEROKU_PREFIX = "NEW_RELIC_";
    private static final String HEROKU_LICENSE_KEY = "NEW_RELIC_LICENSE_KEY";
    private static final String HEROKU_APP_NAME = "NEW_RELIC_APP_NAME";
    private static final String HEROKU_LOG = "NEW_RELIC_LOG";
    private static final String HEROKU_HOST_DISPLAY_NAME = "NEW_RELIC_PROCESS_HOST_DISPLAY_NAME";
    private static final String LICENSE_KEY = "newrelic.config.license_key";
    private static final String APP_NAME = "newrelic.config.app_name";
    private static final String LOG_FILE_NAME = "newrelic.config.log_file_name";
    private static final String HOST_DISPLAY_NAME = "newrelic.config.process_host.display_name";
    private static final String NEW_RELIC_SYSTEM_PROPERTY_ROOT = "newrelic.";
    private final Map<String, String> herokuEnvVars;
    private final Map<String, String> herokuEnvVarsFlattenedMapping;
    private final Map<String, String> newRelicSystemProps;
    private final Map<String, Object> newRelicPropsWithoutPrefix;
    private final SystemProps systemProps;

    public SystemPropertyProvider() {
        this(SystemProps.getSystemProps());
    }

    public SystemPropertyProvider(SystemProps sysProps) {
        this.systemProps = sysProps;
        this.herokuEnvVars = this.initHerokuEnvVariables();
        this.herokuEnvVarsFlattenedMapping = this.initHerokuFlattenedEnvVariables();
        this.newRelicSystemProps = this.initNewRelicSystemProperties();
        this.newRelicPropsWithoutPrefix = this.createNewRelicSystemPropertiesWithoutPrefix();
    }

    private Map<String, String> initHerokuEnvVariables() {
        HashMap<String, String> envVars = new HashMap<String, String>(6);
        envVars.put(LICENSE_KEY, this.getenv(HEROKU_LICENSE_KEY));
        envVars.put(APP_NAME, this.getenv(HEROKU_APP_NAME));
        envVars.put(LOG_FILE_NAME, this.getenv(HEROKU_LOG));
        envVars.put(HOST_DISPLAY_NAME, this.getenv(HEROKU_HOST_DISPLAY_NAME));
        return envVars;
    }

    private Map<String, String> initHerokuFlattenedEnvVariables() {
        HashMap<String, String> envVars = new HashMap<String, String>(6);
        envVars.put(HEROKU_LICENSE_KEY, LICENSE_KEY);
        envVars.put(HEROKU_APP_NAME, APP_NAME);
        envVars.put(HEROKU_LOG, LOG_FILE_NAME);
        envVars.put(HEROKU_HOST_DISPLAY_NAME, HOST_DISPLAY_NAME);
        return envVars;
    }

    private Map<String, String> initNewRelicSystemProperties() {
        HashMap<String, String> nrProps = Maps.newHashMap();
        try {
            for (Map.Entry<Object, Object> entry : this.systemProps.getAllSystemPropertes().entrySet()) {
                String key = entry.getKey().toString();
                if (!key.startsWith(NEW_RELIC_SYSTEM_PROPERTY_ROOT)) continue;
                String val = entry.getValue().toString();
                nrProps.put(key, val);
            }
        }
        catch (SecurityException t) {
            Agent.LOG.log(Level.FINE, "Unable to get system properties");
        }
        return Collections.unmodifiableMap(nrProps);
    }

    private Map<String, Object> createNewRelicSystemPropertiesWithoutPrefix() {
        HashMap<String, Object> nrProps = Maps.newHashMap();
        this.addNewRelicSystemProperties(nrProps, this.systemProps.getAllSystemPropertes().entrySet());
        this.addNewRelicEnvProperties(nrProps, this.systemProps.getAllEnvProperties().entrySet());
        return Collections.unmodifiableMap(nrProps);
    }

    private void addNewRelicSystemProperties(Map<String, Object> nrProps, Set<Map.Entry> entrySet) {
        for (Map.Entry entry : entrySet) {
            String key = entry.getKey().toString();
            if (!key.startsWith("newrelic.config.")) continue;
            this.addPropertyWithoutSystemPropRoot(nrProps, key, entry.getValue());
        }
    }

    private void addNewRelicEnvProperties(Map<String, Object> nrProps, Set<Map.Entry> entrySet) {
        for (Map.Entry entry : entrySet) {
            String key = entry.getKey().toString();
            if (key.startsWith("newrelic.config.")) {
                this.addPropertyWithoutSystemPropRoot(nrProps, key, entry.getValue());
                continue;
            }
            String keyToUse = this.herokuEnvVarsFlattenedMapping.get(key);
            if (keyToUse == null) continue;
            this.addPropertyWithoutSystemPropRoot(nrProps, keyToUse, entry.getValue());
        }
    }

    private void addPropertyWithoutSystemPropRoot(Map<String, Object> nrProps, String key, Object value) {
        String val = value.toString();
        key = key.substring("newrelic.config.".length());
        nrProps.put(key, val);
    }

    public String getEnvironmentVariable(String prop) {
        String val = this.herokuEnvVars.get(prop);
        if (val != null) {
            return val;
        }
        return this.getenv(prop);
    }

    public String getSystemProperty(String prop) {
        return this.systemProps.getSystemProperty(prop);
    }

    private String getenv(String key) {
        return this.systemProps.getenv(key);
    }

    public Map<String, String> getNewRelicSystemProperties() {
        return this.newRelicSystemProps;
    }

    public Map<String, Object> getNewRelicPropertiesWithoutPrefix() {
        return this.newRelicPropsWithoutPrefix;
    }

    protected static abstract class SystemProps {
        protected SystemProps() {
        }

        static SystemProps getSystemProps() {
            try {
                System.getProperties().get("test");
                System.getenv("test");
                return new SystemProps(){

                    @Override
                    String getSystemProperty(String prop) {
                        return System.getProperty(prop);
                    }

                    @Override
                    String getenv(String key) {
                        return System.getenv(key);
                    }

                    @Override
                    Properties getAllSystemPropertes() {
                        return System.getProperties();
                    }

                    @Override
                    Map<String, String> getAllEnvProperties() {
                        return System.getenv();
                    }
                };
            }
            catch (SecurityException e) {
                Agent.LOG.error("Unable to access system properties because of a security exception.");
                return new SystemProps(){

                    @Override
                    String getSystemProperty(String prop) {
                        return null;
                    }

                    @Override
                    String getenv(String key) {
                        return null;
                    }

                    @Override
                    Properties getAllSystemPropertes() {
                        return new Properties();
                    }

                    @Override
                    Map<String, String> getAllEnvProperties() {
                        return Collections.emptyMap();
                    }
                };
            }
        }

        abstract String getSystemProperty(String var1);

        abstract String getenv(String var1);

        abstract Properties getAllSystemPropertes();

        abstract Map<String, String> getAllEnvProperties();
    }
}

