/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigImpl;
import com.newrelic.agent.config.ServerProp;
import com.newrelic.agent.transport.DataSenderWriter;
import java.util.HashMap;
import java.util.Map;

public class AgentConfigFactory {
    public static final String AGENT_CONFIG = "agent_config";
    public static final String PERIOD_REGEX = "\\.";
    public static final String DOT_SEPARATOR = ".";
    public static final String SLOW_SQL_PREFIX = "slow_sql.";
    public static final String TRANSACTION_TRACER_PREFIX = "transaction_tracer.";
    public static final String TRANSACTION_TRACER_CATEGORY_BACKGROUND_PREFIX = "transaction_tracer.category.background.";
    public static final String TRANSACTION_TRACER_CATEGORY_REQUEST_PREFIX = "transaction_tracer.category.request.";
    public static final String ERROR_COLLECTOR_PREFIX = "error_collector.";
    public static final String THREAD_PROFILER_PREFIX = "thread_profiler.";
    public static final String TRANSACTION_EVENTS_PREFIX = "transaction_events.";
    public static final String CUSTOM_INSIGHT_EVENTS_PREFIX = "custom_insights_events.";
    public static final String BROSWER_MONITORING_PREFIX = "browser_monitoring.";
    public static final String HIGH_SECURITY = "high_security";
    public static final String COLLECT_ERRORS = "error_collector.collect_errors";
    public static final String EXPECTED_CLASSES = "error_collector.expected_classes";
    public static final String EXPECTED_STATUS_CODES = "error_collector.expected_status_codes";
    public static final String COLLECT_ERROR_EVENTS = "error_collector.collect_error_events";
    public static final String CAPTURE_ERROR_EVENTS = "error_collector.capture_events";
    public static final String MAX_ERROR_EVENT_SAMPLES_STORED = "error_collector.max_event_samples_stored";
    public static final String COLLECT_TRACES = "transaction_tracer.collect_traces";
    public static final String COLLECT_TRANSACTION_EVENTS = "transaction_events.collect_analytics_events";
    public static final String COLLECT_CUSTOM_INSIGHTS_EVENTS = "custom_insights_events.collect_custom_events";
    public static final String RECORD_SQL = "transaction_tracer.record_sql";
    public static final String SLOW_QUERY_WHITELIST = "transaction_tracer.slow_query_whitelist";
    public static final String CROSS_APPLICATION_TRACER_PREFIX = "cross_application_tracer.";
    public static final String ENCODING_KEY = "cross_application_tracer.encoding_key";
    public static final String CROSS_PROCESS_ID = "cross_application_tracer.cross_process_id";
    public static final String TRUSTED_ACCOUNT_IDS = "cross_application_tracer.trusted_account_ids";
    public static final String STRIP_EXCEPTION = "strip_exception_messages";
    public static final String STRIP_EXCEPTION_ENABLED = "strip_exception_messages.enabled";
    public static final String STRIP_EXCEPTION_WHITELIST = "strip_exception_messages.whitelist";

    public static AgentConfig createAgentConfig(Map<String, Object> localSettings, Map<String, Object> serverData) {
        Map<String, Object> mergedSettings = AgentConfigFactory.createMap(localSettings);
        AgentConfigFactory.mergeServerData(mergedSettings, serverData);
        return AgentConfigImpl.createAgentConfig(mergedSettings);
    }

    public static Map<String, Object> getAgentData(Map<String, Object> serverData) {
        if (serverData == null) {
            return AgentConfigFactory.createMap();
        }
        Map<String, Object> agentData = AgentConfigFactory.createMap((Map)serverData.get(AGENT_CONFIG));
        if (agentData == null || DataSenderWriter.nullValue().equals(agentData)) {
            return AgentConfigFactory.createMap();
        }
        return agentData;
    }

    public static void mergeServerData(Map<String, Object> settings, Map<String, Object> serverData) {
        if (serverData == null) {
            return;
        }
        Map<String, Object> agentData = AgentConfigFactory.getAgentData(serverData);
        agentData.remove("cross_application_tracing");
        agentData.remove(HIGH_SECURITY);
        agentData.remove("reinstrument");
        agentData.remove("reinstrument.attributes_enabled");
        agentData.remove(STRIP_EXCEPTION);
        agentData.remove(STRIP_EXCEPTION_ENABLED);
        agentData.remove(STRIP_EXCEPTION_WHITELIST);
        agentData.remove(SLOW_QUERY_WHITELIST);
        if (AgentConfigFactory.isHighSecurity(settings.get(HIGH_SECURITY))) {
            AgentConfigFactory.removeInvalidHighSecuritySettings(agentData, serverData);
            if (AgentConfigFactory.isValidRecordSqlValue(serverData.get("record_sql"))) {
                AgentConfigFactory.addServerProp(RECORD_SQL, serverData.get("record_sql"), settings);
            }
        } else {
            AgentConfigFactory.addServerProp(RECORD_SQL, serverData.get("record_sql"), settings);
        }
        AgentConfigFactory.addServerProp("transaction_naming_scheme", serverData.get("transaction_naming_scheme"), settings);
        AgentConfigFactory.mergeAgentData(settings, agentData);
        AgentConfigFactory.addServerProp("apdex_t", serverData.get("apdex_t"), settings);
        AgentConfigFactory.addServerProp(COLLECT_ERRORS, serverData.get("collect_errors"), settings);
        AgentConfigFactory.addServerProp(COLLECT_ERROR_EVENTS, serverData.get("collect_error_events"), settings);
        AgentConfigFactory.addServerProp(CAPTURE_ERROR_EVENTS, serverData.get("capture_events"), settings);
        AgentConfigFactory.addServerProp(MAX_ERROR_EVENT_SAMPLES_STORED, serverData.get("max_event_samples_stored"), settings);
        AgentConfigFactory.addServerProp(COLLECT_TRACES, serverData.get("collect_traces"), settings);
        AgentConfigFactory.addServerProp(COLLECT_TRANSACTION_EVENTS, serverData.get("collect_analytics_events"), settings);
        AgentConfigFactory.addServerProp(COLLECT_CUSTOM_INSIGHTS_EVENTS, serverData.get("collect_custom_events"), settings);
        AgentConfigFactory.addServerProp("web_transactions_apdex", serverData.get("web_transactions_apdex"), settings);
        AgentConfigFactory.addServerProp(CROSS_PROCESS_ID, serverData.get("cross_process_id"), settings);
        AgentConfigFactory.addServerProp(ENCODING_KEY, serverData.get("encoding_key"), settings);
        AgentConfigFactory.addServerProp(TRUSTED_ACCOUNT_IDS, serverData.get("trusted_account_ids"), settings);
        AgentConfigFactory.addServerProp("capture_params", serverData.get("capture_params"), settings);
        AgentConfigFactory.addServerProp(EXPECTED_CLASSES, serverData.get("expected_classes"), settings);
        AgentConfigFactory.addServerProp(EXPECTED_STATUS_CODES, serverData.get("expected_status_codes"), settings);
    }

    private static void removeInvalidHighSecuritySettings(Map<String, Object> agentData, Map<String, Object> serverData) {
        agentData.remove("ssl");
        Object recordSql = agentData.get(RECORD_SQL);
        if (!AgentConfigFactory.isValidRecordSqlValue(recordSql)) {
            agentData.remove(RECORD_SQL);
        }
    }

    private static boolean isValidRecordSqlValue(Object recordSqlValue) {
        if (recordSqlValue == null || !(recordSqlValue instanceof String)) {
            return false;
        }
        String rSql = ((String)recordSqlValue).toLowerCase();
        return rSql.equals("off") || rSql.equals("obfuscated");
    }

    private static boolean isHighSecurity(Object value) {
        return value != null && value instanceof Boolean && (Boolean)value != false;
    }

    private static void mergeAgentData(Map<String, Object> settings, Map<String, Object> agentData) {
        for (Map.Entry<String, Object> entry : agentData.entrySet()) {
            AgentConfigFactory.addServerProp(entry.getKey(), entry.getValue(), settings);
        }
    }

    private static void addServerProp(String prop, Object val, Map<String, Object> settings) {
        String[] propArray;
        if (val == null) {
            return;
        }
        Map<String, Object> currentMap = settings;
        int count = 0;
        for (String propPart : propArray = prop.split(PERIOD_REGEX)) {
            if (++count < propArray.length) {
                Map<String, Object> propMap = (Map<String, Object>)currentMap.get(propPart);
                if (propMap == null) {
                    propMap = AgentConfigFactory.createMap();
                    currentMap.put(propPart, propMap);
                }
                currentMap = propMap;
                continue;
            }
            currentMap.put(propPart, ServerProp.createPropObject(val));
        }
    }

    private static Map<String, Object> createMap() {
        return new HashMap<String, Object>();
    }

    public static Map<String, Object> createMap(Map<String, Object> settings) {
        Map<String, Object> result = AgentConfigFactory.createMap();
        if (settings == null) {
            return result;
        }
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            AgentConfigFactory.putOrCreate(entry.getKey(), entry.getValue(), result);
        }
        return result;
    }

    private static void putOrCreate(String key, Object val, Map<String, Object> settings) {
        if (val instanceof Map) {
            settings.put(key, AgentConfigFactory.createMap((Map)val));
        } else {
            settings.put(key, val);
        }
    }
}

