/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.DebugFlag;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.bridge.Token;
import com.newrelic.agent.tracers.Tracer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class TokenImpl
implements Token {
    private volatile Tracer initiatingTracer;
    private final AtomicBoolean active;

    public TokenImpl(Tracer tracer) {
        this.initiatingTracer = tracer;
        this.active = new AtomicBoolean(Boolean.TRUE);
        Transaction tx = this.getTransaction();
        if (tx != null) {
            tx.getMetricAggregator().incrementCounter("Supportability/Async/Token/Create");
        }
        if (DebugFlag.TOKEN.isEnabled()) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StackTraceElement location = stackTrace[4];
            if (location.getMethodName().equals("registerAsyncActivity")) {
                location = stackTrace[5];
            }
            Agent.LOG.log(Level.INFO, "Token: {0} created for Transaction: {1}, at: {2}", new Object[]{this, tx, location.toString()});
        }
    }

    public Transaction getTransaction() {
        Tracer initiatingTracerCopy = this.initiatingTracer;
        if (initiatingTracerCopy != null && initiatingTracerCopy.getTransactionActivity() != null) {
            return initiatingTracerCopy.getTransactionActivity().getTransaction();
        }
        return null;
    }

    public Tracer getInitiatingTracer() {
        return this.initiatingTracer;
    }

    public boolean expire() {
        if (this.active.compareAndSet(Boolean.TRUE, Boolean.FALSE)) {
            Transaction tx = this.getTransaction();
            if (tx != null) {
                tx.getMetricAggregator().incrementCounter("Supportability/Async/Token/Expire");
            }
            boolean expired = Transaction.expireToken(this);
            this.initiatingTracer = null;
            if (DebugFlag.TOKEN.isEnabled()) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                StackTraceElement location = stackTrace[2];
                if (location.getMethodName().equals("registerAsyncActivity") || location.getMethodName().equals("startAsyncActivity") || location.getMethodName().equals("ignoreIfUnstartedAsyncContext")) {
                    location = stackTrace[4];
                } else if (location.getMethodName().equals("linkAndExpire")) {
                    location = stackTrace[3];
                }
                Agent.LOG.log(Level.INFO, "Token: {0} expired for Transaction: {1}, at: {2}", new Object[]{this, tx, location.toString()});
            }
            return expired;
        }
        Agent.LOG.log(Level.FINER, "Token has already been expired {0}.", new Object[]{this});
        return false;
    }

    public boolean link() {
        boolean linked = Transaction.linkTxOnThread(this);
        Transaction tx = this.getTransaction();
        String locationString = null;
        if (DebugFlag.TOKEN.isEnabled()) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StackTraceElement location = stackTrace[2];
            if (location.getMethodName().equals("startAsyncActivity")) {
                location = stackTrace[4];
            } else if (location.getMethodName().equals("linkAndExpire")) {
                location = stackTrace[3];
            }
            locationString = location.toString();
        }
        if (tx != null) {
            if (DebugFlag.TOKEN.isEnabled()) {
                if (!linked && TransactionActivity.get() == null) {
                    Agent.LOG.log(Level.WARNING, "Token: {0} was NOT linked because there was no Transaction in progress. Did you forget to add @Trace(async = true) to: {1}?", new Object[]{this, locationString});
                } else {
                    Agent.LOG.log(Level.INFO, "Token: {0} {1} for Transaction: {2}, at: {3}", new Object[]{this, linked ? "linked" : "link ignored", tx, locationString});
                }
            }
            if (linked) {
                tx.getMetricAggregator().incrementCounter("Supportability/Async/Token/Link/Success");
            } else {
                tx.getMetricAggregator().incrementCounter("Supportability/Async/Token/Link/Ignore");
            }
        }
        return linked;
    }

    public boolean linkAndExpire() {
        boolean linked = this.link();
        boolean expired = this.expire();
        return linked && expired;
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void markExpired() {
        this.active.set(Boolean.FALSE);
        Transaction tx = this.getTransaction();
        if (tx != null) {
            tx.onRemoval();
        }
        this.initiatingTracer = null;
    }

    public void setTruncated() {
        this.initiatingTracer.setMetricNameFormatInfo(this.initiatingTracer.getMetricName(), "Truncated/" + this.initiatingTracer.getMetricName(), this.initiatingTracer.getTransactionSegmentUri());
    }
}

