/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile.visitor;

import com.newrelic.agent.compile.InstrumentationContext;
import com.newrelic.org.objectweb.asm.Label;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import com.newrelic.org.objectweb.asm.Type;
import com.newrelic.org.objectweb.asm.commons.AdviceAdapter;
import com.newrelic.org.objectweb.asm.commons.Method;
import java.util.ArrayList;
import org.slf4j.Logger;

public class TraceMethodVisitor
extends AdviceAdapter {
    protected final InstrumentationContext context;
    protected final Logger log;
    private final String name;
    protected Boolean unloadContext = false;
    protected Boolean startTracing = false;
    private final int access;

    public TraceMethodVisitor(MethodVisitor mv, int access, String name, String desc, InstrumentationContext context) {
        super(589824, mv, access, name, desc);
        this.access = access;
        this.context = context;
        this.log = context.getLog();
        this.name = name;
    }

    public void setUnloadContext() {
        this.unloadContext = true;
    }

    public void setStartTracing() {
        this.startTracing = true;
    }

    @Override
    protected void onMethodEnter() {
        Type targetType = Type.getObjectType("com/newrelic/agent/android/tracing/TraceMachine");
        if (this.startTracing.booleanValue()) {
            super.visitLdcInsn(this.context.getSimpleClassName());
            this.log.debug("[Tracing] Start tracing [" + this.context.getSimpleClassName() + "]");
            super.invokeStatic(targetType, new Method("startTracing", "(Ljava/lang/String;)V"));
        }
        Method traceMachineEnterMethod = new Method("enterMethod", "(Lcom/newrelic/agent/android/tracing/Trace;Ljava/lang/String;Ljava/util/ArrayList;)V");
        if ((this.access & 8) != 0) {
            this.log.debug("[Tracing] Static method [" + this.context.getClassName() + "#" + this.name + "]");
            super.visitInsn(1);
            super.visitLdcInsn(this.context.getSimpleClassName() + "#" + this.name);
            this.emitAnnotationParamsList(this.name);
            super.invokeStatic(targetType, traceMachineEnterMethod);
        } else {
            this.log.debug("[Tracing] Instrumenting method [" + this.context.getClassName() + "#" + this.name + "]");
            Label tryStart = new Label();
            Label tryEnd = new Label();
            Label tryHandler = new Label();
            super.visitTryCatchBlock(tryStart, tryEnd, tryHandler, "java/lang/NoSuchFieldError");
            super.visitLabel(tryStart);
            super.loadThis();
            super.getField(Type.getObjectType(this.context.getClassName()), "_nr_trace", Type.getType("Lcom/newrelic/agent/android/tracing/Trace;"));
            super.visitLdcInsn(this.context.getSimpleClassName() + "#" + this.name);
            this.emitAnnotationParamsList(this.name);
            super.invokeStatic(targetType, traceMachineEnterMethod);
            super.goTo(tryEnd);
            super.visitLabel(tryHandler);
            super.pop();
            super.visitInsn(1);
            super.visitLdcInsn(this.context.getSimpleClassName() + "#" + this.name);
            this.emitAnnotationParamsList(this.name);
            super.invokeStatic(targetType, traceMachineEnterMethod);
            super.visitLabel(tryEnd);
        }
    }

    private void emitAnnotationParamsList(String name) {
        ArrayList<String> annotationParameters = this.context.getTracedMethodParameters(name);
        if (annotationParameters == null || annotationParameters.size() == 0) {
            super.visitInsn(1);
            return;
        }
        Method constructor = Method.getMethod("void <init> ()");
        Method add = Method.getMethod("boolean add(java.lang.Object)");
        Type arrayListType = Type.getObjectType("java/util/ArrayList");
        super.newInstance(arrayListType);
        super.dup();
        super.invokeConstructor(arrayListType, constructor);
        for (String parameterEntry : annotationParameters) {
            super.dup();
            super.visitLdcInsn(parameterEntry);
            super.invokeVirtual(arrayListType, add);
            super.pop();
        }
    }

    @Override
    protected void onMethodExit(int opcode) {
        Type targetType = Type.getObjectType("com/newrelic/agent/android/tracing/TraceMachine");
        super.invokeStatic(targetType, new Method("exitMethod", "()V"));
    }
}

