/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile.visitor;

import com.newrelic.agent.compile.InstrumentationContext;
import com.newrelic.agent.compile.visitor.Annotations;
import com.newrelic.agent.compile.visitor.TraceAnnotationVisitor;
import com.newrelic.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.FieldVisitor;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import java.text.MessageFormat;
import org.slf4j.Logger;

public class PrefilterClassVisitor
extends ClassVisitor {
    private final InstrumentationContext context;
    private final Logger log;

    public PrefilterClassVisitor(InstrumentationContext context, Logger log) {
        super(589824);
        this.context = context;
        this.log = log;
    }

    @Override
    public void visit(int version, int access, String name, String sig, String superName, String[] interfaces) {
        super.visit(version, access, name, sig, superName, interfaces);
        this.context.setClassName(name);
        this.context.setSuperClassName(superName);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (Annotations.isNewRelicAnnotation(desc)) {
            this.log.info(MessageFormat.format("[{0}] class has New Relic tag: {1}", this.context.getClassName(), desc));
            this.context.addTag(desc);
        }
        return null;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String sig, Object value) {
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = new MethodVisitor(589824){

            @Override
            public AnnotationVisitor visitAnnotationDefault() {
                return null;
            }

            @Override
            public AnnotationVisitor visitAnnotation(String annotationDesc, boolean visible) {
                if (annotationDesc.equals("Lcom/newrelic/agent/android/instrumentation/Trace;")) {
                    PrefilterClassVisitor.this.context.addTracedMethod(name, desc);
                    return new TraceAnnotationVisitor(name, PrefilterClassVisitor.this.context);
                }
                if (annotationDesc.equals("Lcom/newrelic/agent/android/instrumentation/SkipTrace;")) {
                    PrefilterClassVisitor.this.context.addSkippedMethod(name, desc);
                    return null;
                }
                return null;
            }

            @Override
            public AnnotationVisitor visitParameterAnnotation(int i, String s, boolean b) {
                return null;
            }
        };
        return methodVisitor;
    }
}

