/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile.visitor;

import com.newrelic.agent.compile.InstrumentationContext;
import com.newrelic.agent.compile.visitor.AgentDelegateClassVisitor;
import com.newrelic.agent.compile.visitor.TraceClassDecorator;
import com.newrelic.agent.compile.visitor.TraceMethodVisitor;
import com.newrelic.com.google.common.collect.ImmutableMap;
import com.newrelic.com.google.common.collect.ImmutableSet;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import com.newrelic.org.objectweb.asm.Type;
import com.newrelic.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.org.objectweb.asm.commons.Method;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class ActivityClassVisitor
extends AgentDelegateClassVisitor {
    static final Type agentDelegateClassType = Type.getObjectType("com/newrelic/agent/android/background/ApplicationStateMonitor");
    static final ImmutableSet<String> ACTIVITY_CLASSES = ImmutableSet.of("^(android\\/.*\\/)(.*Activity)", "^(android\\/app\\/)(ActivityGroup)", "^(android\\/.*\\/)(.*Activity)([DGH].*)", "^(androidx\\/.*\\/)(.*Activity)", "^(androidx\\/)(ActivityCompat)");
    public static final Map<Method, Method> methodDelegateMap = ImmutableMap.of(new Method("onStart", "()V"), new Method("activityStarted", "()V"), new Method("onStop", "()V"), new Method("activityStopped", "()V"));
    public static final ImmutableMap<String, Integer> methodAccessMap = ImmutableMap.of("onStart", 4, "onStop", 4);
    public static final Map<String, String> tracedMethodsMap = ImmutableMap.of("onCreate", "(Landroid/os/Bundle;)V", "onCreateView", "(Landroid/view/LayoutInflater;Landroid/view/ViewGroup;Landroid/os/Bundle;)Landroid/view/View;");
    public static final Set<String> startTracingOn = ImmutableSet.of("onCreate");

    public ActivityClassVisitor(ClassVisitor cv, InstrumentationContext context, Logger log) {
        super(cv, context, log, ACTIVITY_CLASSES, methodDelegateMap, methodAccessMap);
        this.access = 0;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.access = access;
        this.instrument = this.isInstrumentable(name, superName);
        if (this.instrument) {
            interfaces = TraceClassDecorator.addInterface(interfaces);
            this.log.info("[ActivityClassVisitor] Added Trace interface to class[" + this.context.getClassName() + "] superName[" + superName + "]");
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    protected void injectIntoMethod(GeneratorAdapter generatorAdapter, Method method, Method agentDelegateMethod) {
        if (method.getName().equalsIgnoreCase("onStart")) {
            generatorAdapter.invokeStatic(agentDelegateClassType, new Method("getInstance", agentDelegateClassType, new Type[0]));
            generatorAdapter.invokeVirtual(agentDelegateClassType, agentDelegateMethod);
            this.log.debug("[ActivityClassVisitor] injecting onStart method");
        } else if (method.getName().equalsIgnoreCase("onStop")) {
            generatorAdapter.invokeStatic(agentDelegateClassType, new Method("getInstance", agentDelegateClassType, new Type[0]));
            generatorAdapter.invokeVirtual(agentDelegateClassType, agentDelegateMethod);
            this.log.debug("[ActivityClassVisitor] injecting onStop method");
        } else if (method.getName().equalsIgnoreCase("onBackPressed")) {
            this.log.debug("[ActivityClassVisitor] injecting onBackPressed method");
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
        if (this.context.isSkippedMethod(methodName, desc)) {
            this.log.debug("[ActivityClassVisitor] @SkipTrace applied to method [" + methodName + ", " + desc + "]");
        } else if (this.instrument && tracedMethodsMap.containsKey(methodName) && tracedMethodsMap.get(methodName).equals(desc)) {
            this.log.info("[ActivityClassVisitor] Tracing method [" + methodName + "]");
            MethodVisitor methodVisitor = super.visitMethod(access, methodName, desc, signature, exceptions);
            TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor(methodVisitor, access, methodName, desc, this.context);
            if (startTracingOn.contains(methodName)) {
                this.log.debug("[ActivityClassVisitor] Start new trace for [" + methodName + "]");
                traceMethodVisitor.setStartTracing();
            }
            return traceMethodVisitor;
        }
        return super.visitMethod(access, methodName, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        if (this.instrument) {
            TraceClassDecorator decorator = new TraceClassDecorator(this);
            decorator.addTraceField();
            this.log.debug("[ActivityClassVisitor] Added Trace object to " + this.context.getClassName());
            if ((this.access & 0x400) != 0) {
                this.log.info("[ActivityClassVisitor] Abstract base class: adding TraceFieldInterface impl to [" + this.context.getClassName() + "]");
                decorator.addTraceInterface(Type.getObjectType(this.context.getClassName()));
            }
        }
        this.access = 0;
        super.visitEnd();
    }
}

