/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile;

import com.newrelic.agent.compile.Logger;
import com.newrelic.org.slf4j.event.Level;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Map;

public final class FileLogger
extends Logger {
    static final String newLn = System.getProperty("line.separator", "\r\n");
    private final PrintWriter writer;

    public FileLogger(Map<String, String> agentOptions, String logFileName) {
        super(agentOptions);
        try {
            this.writer = new PrintWriter(new FileOutputStream(logFileName));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void log(String level, String message) {
        FileLogger fileLogger = this;
        synchronized (fileLogger) {
            this.writer.write("[" + level + "] [newrelic] " + message + newLn);
            this.writer.flush();
        }
    }

    @Override
    protected void log(Level level, String message) {
        this.log(level.name(), message);
    }

    @Override
    public void warn(String message, Throwable cause) {
        if (this.isLevelEnabled(Level.WARN)) {
            this.log(Level.WARN, message);
            cause.printStackTrace(this.writer);
            this.writer.flush();
        }
    }

    @Override
    public void error(String message, Throwable cause) {
        if (this.isLevelEnabled(Level.ERROR)) {
            this.log(Level.ERROR, message);
            cause.printStackTrace(this.writer);
            this.writer.flush();
        }
    }
}

