/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.unity;

import com.newrelic.agent.android.NewRelic;
import com.newrelic.agent.android.crash.UncaughtExceptionHandler;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.unity.UnityEvent;
import com.newrelic.agent.android.unity.UnityException;
import com.newrelic.agent.android.util.NetworkFailure;

public class NewRelicUnity {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final String ROOT_TRACE_NAME = "Unity";

    static void handleUnityCrash(UnityException ex) {
        Thread.UncaughtExceptionHandler currentExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentExceptionHandler != null && currentExceptionHandler instanceof UncaughtExceptionHandler) {
            currentExceptionHandler.uncaughtException(Thread.currentThread(), ex);
        }
    }

    static boolean recordEvent(UnityEvent event) {
        return NewRelic.recordEvent(event.getName(), event.getAttributes());
    }

    static void noticeNetworkFailure(String url, String httpMethod, long startTime, long endTime, int failureCode, String message) {
        NetworkFailure networkFailure = NetworkFailure.fromErrorCode(failureCode);
        NewRelic.noticeNetworkFailure(url, httpMethod, startTime, endTime, networkFailure, message);
    }
}

