/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.tracing;

import com.newrelic.agent.android.instrumentation.MetricCategory;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.tracing.TraceMachine;
import com.newrelic.agent.android.tracing.TraceType;
import com.newrelic.agent.android.tracing.TracingInactiveException;
import com.newrelic.agent.android.util.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class Trace {
    private static final String CATEGORY_PARAMETER = "category";
    private static final AgentLog log = AgentLogManager.getAgentLog();
    public final UUID parentUUID;
    public final UUID myUUID = new UUID(Util.getRandom().nextLong(), Util.getRandom().nextLong());
    public long entryTimestamp = 0L;
    public long exitTimestamp = 0L;
    public long exclusiveTime = 0L;
    public long childExclusiveTime = 0L;
    public String metricName;
    public String metricBackgroundName;
    public String displayName;
    public String scope;
    public long threadId = 0L;
    public String threadName = "main";
    private volatile Map<String, Object> params;
    private List<String> rawAnnotationParams;
    private volatile Set<UUID> children;
    private TraceType type = TraceType.TRACE;
    private boolean isComplete = false;
    public TraceMachine traceMachine;

    public Trace() {
        this.parentUUID = null;
    }

    public Trace(String displayName, UUID parentUUID, TraceMachine traceMachine) {
        this.displayName = displayName;
        this.parentUUID = parentUUID;
        this.traceMachine = traceMachine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(Trace trace) {
        if (this.children == null) {
            Trace trace2 = this;
            synchronized (trace2) {
                if (this.children == null) {
                    this.children = Collections.synchronizedSet(new HashSet());
                }
            }
        }
        this.children.add(trace.myUUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<UUID> getChildren() {
        if (this.children == null) {
            Trace trace = this;
            synchronized (trace) {
                if (this.children == null) {
                    this.children = Collections.synchronizedSet(new HashSet());
                }
            }
        }
        return this.children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getParams() {
        if (this.params == null) {
            Trace trace = this;
            synchronized (trace) {
                if (this.params == null) {
                    this.params = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        return this.params;
    }

    public void setAnnotationParams(List<String> rawAnnotationParams) {
        this.rawAnnotationParams = rawAnnotationParams;
    }

    public Map<String, Object> getAnnotationParams() {
        HashMap<String, Object> annotationParams = new HashMap<String, Object>();
        if (this.rawAnnotationParams != null && this.rawAnnotationParams.size() > 0) {
            Iterator<String> i = this.rawAnnotationParams.iterator();
            while (i.hasNext()) {
                String paramValue;
                String paramClass;
                String paramName = i.next();
                Object param = Trace.createParameter(paramName, paramClass = i.next(), paramValue = i.next());
                if (param == null) continue;
                annotationParams.put(paramName, param);
            }
        }
        return annotationParams;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void complete() throws TracingInactiveException {
        if (this.isComplete) {
            log.warning("Attempted to double complete trace " + this.myUUID.toString());
            return;
        }
        if (this.exitTimestamp == 0L) {
            this.exitTimestamp = System.currentTimeMillis();
        }
        this.exclusiveTime = this.getDurationAsMilliseconds() - this.childExclusiveTime;
        this.isComplete = true;
        try {
            this.traceMachine.storeCompletedTrace(this);
        }
        catch (NullPointerException e) {
            throw new TracingInactiveException();
        }
    }

    public void prepareForSerialization() {
        this.getParams().put("type", this.type.toString());
    }

    public TraceType getType() {
        return this.type;
    }

    public void setType(TraceType type) {
        this.type = type;
    }

    public long getDurationAsMilliseconds() {
        return this.exitTimestamp - this.entryTimestamp;
    }

    public float getDurationAsSeconds() {
        return (float)(this.exitTimestamp - this.entryTimestamp) / 1000.0f;
    }

    public MetricCategory getCategory() {
        if (!this.getAnnotationParams().containsKey(CATEGORY_PARAMETER)) {
            return null;
        }
        Object category = this.getAnnotationParams().get(CATEGORY_PARAMETER);
        if (!(category instanceof MetricCategory)) {
            log.error("Category annotation parameter is not of type MetricCategory");
            return null;
        }
        return (MetricCategory)((Object)category);
    }

    private static Object createParameter(String parameterName, String parameterClass, String parameterValue) {
        Class<?> clazz;
        try {
            clazz = Class.forName(parameterClass);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to resolve parameter class in enterMethod: " + e.getMessage(), e);
            return null;
        }
        if (MetricCategory.class == clazz) {
            return MetricCategory.valueOf(parameterValue);
        }
        if (String.class == clazz) {
            return parameterValue;
        }
        return null;
    }
}

