/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.measurement.producer;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.measurement.MeasurementType;
import com.newrelic.agent.android.measurement.ThreadInfo;
import com.newrelic.agent.android.measurement.http.HttpErrorMeasurement;
import com.newrelic.agent.android.measurement.producer.BaseMeasurementProducer;
import com.newrelic.agent.android.util.Util;
import java.util.HashMap;
import java.util.Map;

public class HttpErrorMeasurementProducer
extends BaseMeasurementProducer {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    public static final String HTTP_METHOD_PARAMS_KEY = "http_method";
    public static final String WAN_TYPE_PARAMS_KEY = "wan_type";

    public HttpErrorMeasurementProducer() {
        super(MeasurementType.HttpError);
    }

    public void produceMeasurement(String urlString, String httpMethod, int statusCode, int errorCode, String responseBody, Map<String, String> params, ThreadInfo threadInfo) {
        HttpErrorMeasurement measurement = new HttpErrorMeasurement(urlString, statusCode);
        measurement.setHttpMethod(httpMethod);
        measurement.setErrorCode(errorCode);
        measurement.setResponseBody(responseBody);
        measurement.setParams(params);
        measurement.setThreadInfo(threadInfo);
        measurement.setTotalTime(0.0);
        this.produceMeasurement(measurement);
    }

    public void produceMeasurement(HttpErrorMeasurement httpErrorMeasurement) {
        String url = Util.sanitizeUrl(httpErrorMeasurement.getUrl());
        if (url == null) {
            log.error("HttpErrorMeasurementProducer.produceMeasurement: URL is null");
            return;
        }
        Map<String, String> params = httpErrorMeasurement.getParams();
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put(HTTP_METHOD_PARAMS_KEY, httpErrorMeasurement.getHttpMethod());
        params.put(WAN_TYPE_PARAMS_KEY, Agent.getActiveNetworkWanType());
        httpErrorMeasurement.setUrl(url);
        httpErrorMeasurement.setParams(params);
        httpErrorMeasurement.setStackTrace(this.getSanitizedStackTrace());
        httpErrorMeasurement.setWanType(Agent.getActiveNetworkWanType());
        super.produceMeasurement(httpErrorMeasurement);
    }

    private String getSanitizedStackTrace() {
        StringBuilder stackTrace = new StringBuilder();
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        int numErrors = 0;
        for (int i = 0; i < stackTraceElements.length; ++i) {
            StackTraceElement frame = stackTraceElements[i];
            if (this.shouldFilterStackTraceElement(frame)) continue;
            stackTrace.append(frame.toString());
            if (i <= stackTraceElements.length - 1) {
                stackTrace.append("\n");
            }
            if (++numErrors >= Agent.getStackTraceLimit()) break;
        }
        return stackTrace.toString();
    }

    private boolean shouldFilterStackTraceElement(StackTraceElement element) {
        String className = element.getClassName();
        String method = element.getMethodName();
        if (className.startsWith("com.newrelic")) {
            return true;
        }
        if (className.startsWith("dalvik.system.VMStack") && method.startsWith("getThreadStackTrace")) {
            return true;
        }
        return className.startsWith("java.lang.Thread") && method.startsWith("getStackTrace");
    }
}

