/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.measurement.http;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.distributedtracing.TraceContext;
import com.newrelic.agent.android.measurement.BaseMeasurement;
import com.newrelic.agent.android.measurement.MeasurementType;
import java.util.Map;

public class HttpErrorMeasurement
extends BaseMeasurement {
    private String url = null;
    private int statusCode = 0;
    private int errorCode = 0;
    private String responseBody = null;
    private String stackTrace = null;
    private Map<String, String> params = null;
    private String httpMethod = null;
    private String wanType = Agent.getActiveNetworkWanType();
    private double totalTime = 0.0;
    private long bytesSent = 0L;
    private long bytesReceived = 0L;
    private String appData = null;
    private TraceContext traceContext = null;

    public HttpErrorMeasurement() {
        super(MeasurementType.HttpError);
        this.setStartTime(System.currentTimeMillis());
    }

    public HttpErrorMeasurement(String url, int statusCode) {
        this();
        this.setUrl(url);
        this.setName(url);
        this.setStatusCode(statusCode);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setResponseBody(String responseBody) {
        if (FeatureFlag.featureEnabled(FeatureFlag.HttpResponseBodyCapture)) {
            this.responseBody = responseBody == null || responseBody.isEmpty() ? null : responseBody;
        }
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public String getUrl() {
        return this.url;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getWanType() {
        return this.wanType;
    }

    public void setWanType(String wanType) {
        this.wanType = wanType;
    }

    public double getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(double totalTime) {
        this.totalTime = totalTime;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public void setBytesSent(long bytesSent) {
        this.bytesSent = bytesSent;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public void setBytesReceived(long bytesReceived) {
        this.bytesReceived = bytesReceived;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setAppData(String appData) {
        this.appData = appData;
    }

    public String getAppData() {
        return this.appData;
    }

    public void setTraceContext(TraceContext traceContext) {
        this.traceContext = traceContext;
    }

    public TraceContext getTraceContext() {
        return this.traceContext;
    }
}

