/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.retrofit;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.distributedtracing.DistributedTracing;
import com.newrelic.agent.android.distributedtracing.TraceContext;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.instrumentation.retrofit.ContentBufferingTypedInput;
import com.newrelic.agent.android.instrumentation.retrofit.RetrofitTransactionStateUtil;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import java.io.IOException;
import java.util.ArrayList;
import retrofit.client.Client;
import retrofit.client.Header;
import retrofit.client.Request;
import retrofit.client.Response;
import retrofit.mime.TypedInput;

public class ClientExtension
implements Client {
    private Client impl;
    private TransactionState transactionState;
    private Request request;

    public ClientExtension(Client impl) {
        this.impl = impl;
    }

    public Response execute(Request request) throws IOException {
        Response response;
        this.request = request;
        this.transactionState = this.getTransactionState();
        request = this.setCrossProcessHeaders(request);
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            TraceContext trace = DistributedTracing.getInstance().startTrace(this.transactionState);
            this.transactionState.setTrace(trace);
            request = RetrofitTransactionStateUtil.setDistributedTraceHeaders(this.transactionState, request);
        }
        try {
            response = this.impl.execute(request);
            response = new Response(response.getUrl(), response.getStatus(), response.getReason(), response.getHeaders(), (TypedInput)new ContentBufferingTypedInput(response.getBody()));
        }
        catch (IOException ex) {
            this.error(ex);
            throw ex;
        }
        this.checkResponse(response);
        return response;
    }

    private Request setCrossProcessHeaders(Request request) {
        String crossProcessId = Agent.getCrossProcessId();
        ArrayList<Header> headers = new ArrayList<Header>(request.getHeaders());
        if (crossProcessId != null) {
            headers.add(new Header("X-NewRelic-ID", crossProcessId));
        }
        return new Request(request.getMethod(), request.getUrl(), headers, request.getBody());
    }

    private void checkResponse(Response response) {
        if (!this.getTransactionState().isComplete()) {
            RetrofitTransactionStateUtil.inspectAndInstrumentResponse(this.getTransactionState(), response);
        }
    }

    protected TransactionState getTransactionState() {
        if (this.transactionState == null) {
            this.transactionState = new TransactionState();
        }
        RetrofitTransactionStateUtil.inspectAndInstrument(this.transactionState, this.request);
        return this.transactionState;
    }

    protected void error(Exception e) {
        TransactionData transactionData;
        TransactionState transactionState = this.getTransactionState();
        TransactionStateUtil.setErrorCodeFromException(transactionState, e);
        if (!transactionState.isComplete() && (transactionData = transactionState.end()) != null) {
            transactionData.setResponseBody(e.toString());
            TaskQueue.queue(new HttpTransactionMeasurement(transactionData));
        }
    }

    void setRequest(Request request) {
        this.request = request;
    }
}

