/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.distributedtracing.DistributedTracing;
import com.newrelic.agent.android.distributedtracing.TraceContext;
import com.newrelic.agent.android.distributedtracing.TraceHeader;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.util.ExceptionHelper;
import java.io.IOException;
import java.net.HttpURLConnection;

public class TransactionStateUtil {
    protected static final AgentLog log = AgentLogManager.getAgentLog();
    protected static final long CONTENTLENGTH_UNKNOWN = -1L;

    public static void inspectAndInstrument(TransactionState transactionState, String url, String httpMethod) {
        transactionState.setUrl(url);
        transactionState.setHttpMethod(httpMethod);
        transactionState.setCarrier(Agent.getActiveNetworkCarrier());
        transactionState.setWanType(Agent.getActiveNetworkWanType());
    }

    public static void inspectAndInstrument(TransactionState transactionState, HttpURLConnection conn) {
        TransactionStateUtil.inspectAndInstrument(transactionState, conn.getURL().toString(), conn.getRequestMethod());
    }

    public static void inspectAndInstrumentResponse(TransactionState transactionState, String appData, int contentLength, int statusCode) {
        if (appData != null && !appData.equals("")) {
            transactionState.setAppData(appData);
        }
        if (contentLength >= 0) {
            transactionState.setBytesReceived(contentLength);
        }
        transactionState.setStatusCode(statusCode);
    }

    public static void inspectAndInstrumentResponse(TransactionState transactionState, HttpURLConnection conn) {
        String appData = null;
        int contentLength = -1;
        int statusCode = 0;
        try {
            contentLength = conn.getContentLength();
            statusCode = conn.getResponseCode();
            appData = conn.getHeaderField("X-NewRelic-App-Data");
        }
        catch (IllegalStateException e) {
            log.debug("Failed to retrieve response data on a closed connection: " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            log.debug("Failed to retrieve response data due to an I/O exception: " + e.getLocalizedMessage());
        }
        catch (NullPointerException e) {
            log.error("Failed to retrieve response code due to underlying (Harmony?) NPE" + e.getLocalizedMessage());
        }
        TransactionStateUtil.inspectAndInstrumentResponse(transactionState, appData, contentLength, statusCode);
    }

    public static void setErrorCodeFromException(TransactionState transactionState, Exception e) {
        int exceptionAsErrorCode = ExceptionHelper.exceptionToErrorCode(e);
        log.error("TransactionStateUtil: Attempting to convert network exception " + e.getClass().getName() + " to error code.");
        transactionState.setErrorCode(exceptionAsErrorCode);
    }

    public static void setTrace(TransactionState transactionState) {
        if (transactionState.getTrace() == null) {
            TraceContext trace = DistributedTracing.getInstance().startTrace(transactionState);
            transactionState.setTrace(trace);
        }
    }

    static void setDistributedTraceHeaders(TransactionState transactionState, HttpURLConnection conn) {
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            try {
                TraceContext traceContext = transactionState.getTrace();
                if (traceContext != null) {
                    for (TraceHeader traceHeader : traceContext.getHeaders()) {
                        conn.addRequestProperty(traceHeader.getHeaderName(), traceHeader.getHeaderValue());
                    }
                    TraceContext.reportSupportabilityMetrics();
                }
            }
            catch (Exception e) {
                log.error("setDistributedTraceHeaders: Unable to add trace headers. ", e);
                TraceContext.reportSupportabilityExceptionMetric(e);
            }
        }
    }

    public static void setCrossProcessHeader(HttpURLConnection conn) {
        try {
            String crossProcessId = Agent.getCrossProcessId();
            if (crossProcessId != null) {
                conn.setRequestProperty("X-NewRelic-ID", crossProcessId);
            }
        }
        catch (Exception e) {
            log.error("setCrossProcessHeader: " + e.getLocalizedMessage());
        }
    }
}

