/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.distributedtracing;

import com.newrelic.agent.android.distributedtracing.DistributedTracing;
import com.newrelic.agent.android.distributedtracing.TraceContext;
import com.newrelic.agent.android.distributedtracing.TraceHeader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class TraceState
implements TraceHeader {
    public static final String TRACE_STATE_HEADER = "tracestate";
    static final int TRACE_STATE_VERSION = 0;
    static final int TRACE_STATE_PARENT_TYPE = 2;
    final TraceContext traceContext;
    final long timestampMs;
    final Map<String, String> entries;

    public static TraceState createTraceState(TraceContext traceContext) {
        return new W3CTraceState(traceContext);
    }

    TraceState(TraceContext traceContext) {
        this.traceContext = traceContext;
        this.timestampMs = DistributedTracing.generateNormalizedTimestamp();
        this.entries = new HashMap<String, String>();
    }

    @Override
    public String getHeaderName() {
        return TRACE_STATE_HEADER;
    }

    static class W3CTraceState
    extends TraceState {
        static final String TRACE_STATE_HEADER_FMT = "%1d-%1d-%s-%s-%s-%s-%s-%s-%d";
        static final String TRACE_STATE_HEADER_REGEX = "^(\\d+)?@nr=(\\d)-(\\d)-(\\d+)?-(\\d+)?-(\\w+)?-(\\w)?-(\\d{1,2})?-(\\w)?-(\\d+)$";
        static final String TRACE_STATE_VENDOR_REGEX = "^(\\d+?)(@nr)(=.*)?";
        static final String TRACE_STATE_ENTRY_REGEX = "(\\d)-(\\d+)-(\\d+)?-(\\d+)?-(\\w*)?-(\\w+)?-(\\d{1,2})?-(\\w)?-(\\d+)$";

        W3CTraceState(TraceContext traceContext) {
            super(traceContext);
            this.entries.put(traceContext.getVendor(), this.getVendorState());
        }

        @Override
        public String getHeaderValue() {
            StringBuilder builder = new StringBuilder();
            for (String key : this.entries.keySet()) {
                builder.append(String.format("%s=%s,", key, this.entries.get(key)));
            }
            builder.deleteCharAt(builder.length() - 1);
            return builder.toString();
        }

        String getVendorState() {
            return String.format(Locale.ROOT, TRACE_STATE_HEADER_FMT, 0, 2, this.traceContext.getAccountId(), this.traceContext.getApplicationId(), this.traceContext.getParentId(), "", "", "", this.timestampMs);
        }
    }
}

