/*
 * Decompiled with CFR 0.152.
 */
package com.memorymd.bluetoothle;

import android.bluetooth.le.ScanResult;
import com.memorymd.bluetoothle.BluetoothDeviceWrapper;
import com.memorymd.bluetoothle.IBluetoothDevice;
import com.memorymd.bluetoothle.IScanRecord;
import com.memorymd.bluetoothle.IScanResult;
import com.memorymd.bluetoothle.ScanRecordWrapper;

public class ScanResultWrapper
implements IScanResult {
    private final ScanResult mResult;

    public ScanResultWrapper(ScanResult scanResult) {
        if (scanResult == null) {
            throw new IllegalArgumentException("ScanResult cannot be null");
        }
        this.mResult = scanResult;
    }

    @Override
    public IBluetoothDevice getDevice() {
        return new BluetoothDeviceWrapper(this.mResult.getDevice());
    }

    @Override
    public IScanRecord getScanRecord() {
        return new ScanRecordWrapper(this.mResult.getScanRecord());
    }

    @Override
    public int getRssi() {
        return this.mResult.getRssi();
    }

    @Override
    public long getTimestampNanos() {
        return this.mResult.getTimestampNanos();
    }
}

