/*
 * Decompiled with CFR 0.152.
 */
package com.memorymd.bluetoothle;

import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.util.Log;
import com.memorymd.bluetoothle.BleScanCallback;
import com.memorymd.bluetoothle.IScanResult;
import com.memorymd.bluetoothle.ScanResultWrapper;
import java.util.ArrayList;
import java.util.List;

public class ScanCallbackAdapter
extends ScanCallback {
    private final BleScanCallback mScanCallback;

    public ScanCallbackAdapter(long l) {
        this.mScanCallback = new BleScanCallback(l);
    }

    public void onBatchScanResults(List<ScanResult> list) {
        try {
            ArrayList<IScanResult> arrayList = new ArrayList<IScanResult>();
            for (ScanResult scanResult : list) {
                arrayList.add(new ScanResultWrapper(scanResult));
            }
            this.mScanCallback.onBatchScanResults(arrayList);
        }
        catch (Exception exception) {
            Log.e((String)"ScanCallbackAdapter", (String)String.format("Exception in batch scan result handler: %s", exception.getMessage()));
        }
    }

    public void onScanFailed(int n) {
        try {
            this.mScanCallback.onScanFailed(n);
        }
        catch (Exception exception) {
            Log.e((String)"ScanCallbackAdapter", (String)String.format("Exception in scan failed handler: %s", exception.getMessage()));
        }
    }

    public void onScanResult(int n, ScanResult scanResult) {
        try {
            this.mScanCallback.onScanResult(n, new ScanResultWrapper(scanResult));
        }
        catch (Exception exception) {
            Log.e((String)"ScanCallbackAdapter", (String)String.format("Exception in scan result handler: %s", exception.getMessage()));
        }
    }
}

