/*
 * Decompiled with CFR 0.152.
 */
package com.memorymd.bluetoothle;

import android.util.Log;
import com.memorymd.bluetoothle.IScanResult;
import java.util.List;

public class BleScanCallback {
    private final long mNativeCallbackPtr;

    public BleScanCallback(long l) {
        this.mNativeCallbackPtr = l;
    }

    public void finalize() {
        BleScanCallback.destroyNativeCallbackLink(this.mNativeCallbackPtr);
    }

    public void onBatchScanResults(List<IScanResult> list) {
        try {
            BleScanCallback.onBatchScanResults(this.mNativeCallbackPtr, list);
        }
        catch (Exception exception) {
            Log.e((String)"BleScanCallback", (String)String.format("Exception in batch scan result handler: %s", exception.getMessage()));
        }
    }

    public void onScanFailed(int n) {
        try {
            BleScanCallback.onScanFailed(this.mNativeCallbackPtr, n);
        }
        catch (Exception exception) {
            Log.e((String)"BleScanCallback", (String)String.format("Exception in scan failed handler: %s", exception.getMessage()));
        }
    }

    public void onScanResult(int n, IScanResult iScanResult) {
        try {
            BleScanCallback.onScanResult(this.mNativeCallbackPtr, n, iScanResult);
        }
        catch (Exception exception) {
            Log.e((String)"BleScanCallback", (String)String.format("Exception in scan result handler: %s", exception.getMessage()));
        }
    }

    private static native void destroyNativeCallbackLink(long var0);

    private static native void onScanResult(long var0, int var2, IScanResult var3);

    private static native void onScanFailed(long var0, int var2);

    private static native void onBatchScanResults(long var0, List<IScanResult> var2);
}

