/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.INotificationCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SubscribersNotifier<T> {
    private List<INotificationCallback<T>> mSubscribers = Collections.synchronizedList(new ArrayList());

    public void subscribe(INotificationCallback<T> callback) {
        if (this.mSubscribers.contains(callback)) {
            return;
        }
        this.mSubscribers.add(callback);
    }

    public void unsubscribe(INotificationCallback<T> callback) {
        this.mSubscribers.remove(callback);
    }

    public void unsubscribe() {
        this.mSubscribers.clear();
    }

    public void sendNotification(Object sender, T param) {
        for (INotificationCallback<T> subscriber : this.mSubscribers) {
            if (subscriber == null) continue;
            subscriber.onNotify(sender, param);
        }
    }
}

