/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.AnyChannel;
import com.neuromd.neurosdk.AnyChannelLengthChangedCallback;
import com.neuromd.neurosdk.BaseDoubleChannel;
import com.neuromd.neurosdk.ChannelInfo;
import com.neuromd.neurosdk.DoubleDataChannel;
import com.neuromd.neurosdk.RPeakChannel;

public class StressIndexChannel
extends BaseDoubleChannel {
    private final RPeakChannel mChannel;
    private final AnyChannel mAnyChannel;
    private final DoubleDataChannel mDataChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback(){

        @Override
        public void onDataLengthChanged(int dataLength) {
            StressIndexChannel.this.dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public StressIndexChannel(RPeakChannel rPeakChannel) {
        this.mChannel = rPeakChannel;
        this.mAnyChannel = new AnyChannel(StressIndexChannel.createStressIndexChannel(this.mChannel.channelPtr()), this.lengthChangedCallback);
        this.mDataChannel = new DoubleDataChannel(this.mAnyChannel);
    }

    @Override
    public void close() {
        this.mAnyChannel.close();
    }

    @Override
    public ChannelInfo info() {
        return this.mAnyChannel.info();
    }

    @Override
    public int totalLength() {
        return this.mAnyChannel.totalLength();
    }

    @Override
    public float samplingFrequency() {
        return this.mAnyChannel.samplingFrequency();
    }

    @Override
    public long channelPtr() {
        return this.mAnyChannel.channelPtr();
    }

    @Override
    public double[] readData(int offset, int length) {
        return this.mDataChannel.readData(offset, length);
    }

    private static native long createStressIndexChannel(long var0);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

