/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.AnyChannel;
import com.neuromd.neurosdk.AnyChannelLengthChangedCallback;
import com.neuromd.neurosdk.BaseDoubleChannel;
import com.neuromd.neurosdk.ChannelInfo;
import com.neuromd.neurosdk.DoubleDataChannel;
import com.neuromd.neurosdk.SpectrumChannel;

public class SpectrumPowerChannel
extends BaseDoubleChannel {
    private final SpectrumChannel[] mChannels;
    private final AnyChannel mAnyChannel;
    private final DoubleDataChannel mDataChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback(){

        @Override
        public void onDataLengthChanged(int dataLength) {
            SpectrumPowerChannel.this.dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public SpectrumPowerChannel(SpectrumChannel[] channels, float lowFrequency, float highFrequency, String name, double windowDuration, double overlapCoeff) {
        this.mChannels = channels;
        this.mAnyChannel = new AnyChannel(SpectrumPowerChannel.createSpectrumPowerDoubleChannel(this.mChannels, lowFrequency, highFrequency, name, windowDuration, overlapCoeff), this.lengthChangedCallback);
        this.mDataChannel = new DoubleDataChannel(this.mAnyChannel);
    }

    public SpectrumPowerChannel(SpectrumChannel[] channels, float lowFrequency, float highFrequency, String name, double windowDuration) {
        this.mChannels = channels;
        this.mAnyChannel = new AnyChannel(SpectrumPowerChannel.createSpectrumPowerDoubleChannel(this.mChannels, lowFrequency, highFrequency, name, windowDuration, 0.95), this.lengthChangedCallback);
        this.mDataChannel = new DoubleDataChannel(this.mAnyChannel);
    }

    public SpectrumPowerChannel(SpectrumChannel[] channels, float lowFrequency, float highFrequency, String name) {
        this.mChannels = channels;
        this.mAnyChannel = new AnyChannel(SpectrumPowerChannel.createSpectrumPowerDoubleChannel(this.mChannels, lowFrequency, highFrequency, name, 8.0, 0.95), this.lengthChangedCallback);
        this.mDataChannel = new DoubleDataChannel(this.mAnyChannel);
    }

    @Override
    public void close() {
        this.mAnyChannel.close();
    }

    @Override
    public ChannelInfo info() {
        return this.mAnyChannel.info();
    }

    @Override
    public int totalLength() {
        return this.mAnyChannel.totalLength();
    }

    @Override
    public float samplingFrequency() {
        return this.mAnyChannel.samplingFrequency();
    }

    @Override
    public long channelPtr() {
        return this.mAnyChannel.channelPtr();
    }

    @Override
    public double[] readData(int offset, int length) {
        return this.mDataChannel.readData(offset, length);
    }

    public void setWindowDuration(double duration) {
        SpectrumPowerChannel.setWindowDuration(this.channelPtr(), duration);
    }

    public void setOverlappingCoefficient(double coefficient) {
        SpectrumPowerChannel.setOverlappingCoefficient(this.channelPtr(), coefficient);
    }

    public static double spectrumPower(float lowFrequency, float highFrequency, double[] spectrum, float frequencyStep) {
        return SpectrumPowerChannel.spectrumPowerNormalized(lowFrequency, highFrequency, spectrum, frequencyStep);
    }

    private static native long createSpectrumPowerDoubleChannel(SpectrumChannel[] var0, float var1, float var2, String var3, double var4, double var6);

    private static native void setOverlappingCoefficient(long var0, double var2);

    private static native void setWindowDuration(long var0, double var2);

    private static native double spectrumPowerNormalized(float var0, float var1, double[] var2, float var3);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

