/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.AnyChannel;
import com.neuromd.neurosdk.AnyChannelLengthChangedCallback;
import com.neuromd.neurosdk.BaseDoubleChannel;
import com.neuromd.neurosdk.ChannelInfo;

public class SpectrumChannel
extends BaseDoubleChannel {
    private final BaseDoubleChannel mChannel;
    private final AnyChannel mAnyChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback(){

        @Override
        public void onDataLengthChanged(int dataLength) {
            SpectrumChannel.this.dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public SpectrumChannel(BaseDoubleChannel channel) {
        this.mChannel = channel;
        this.mAnyChannel = new AnyChannel(SpectrumChannel.createSpectrumDoubleChannel(this.mChannel.channelPtr()), this.lengthChangedCallback);
    }

    @Override
    public void close() {
        this.mAnyChannel.close();
    }

    @Override
    public ChannelInfo info() {
        return this.mAnyChannel.info();
    }

    @Override
    public int totalLength() {
        return this.mAnyChannel.totalLength();
    }

    @Override
    public float samplingFrequency() {
        return this.mAnyChannel.samplingFrequency();
    }

    @Override
    public long channelPtr() {
        return this.mAnyChannel.channelPtr();
    }

    @Override
    public double[] readData(int offset, int length) {
        return SpectrumChannel.readData(this.channelPtr(), offset, length);
    }

    public double hzPerSpectrumSample() {
        return SpectrumChannel.SpectrumDoubleChannelGetHzPerSpectrumSample(this.mAnyChannel.channelPtr());
    }

    public int spectrumLength() {
        return SpectrumChannel.SpectrumDoubleChannelGetSpectrumLength(this.mAnyChannel.channelPtr());
    }

    private static native long createSpectrumDoubleChannel(long var0);

    private static native double SpectrumDoubleChannelGetHzPerSpectrumSample(long var0);

    private static native int SpectrumDoubleChannelGetSpectrumLength(long var0);

    public static native double[] readData(long var0, int var2, int var3);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

