/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.AnyChannel;
import com.neuromd.neurosdk.AnyChannelLengthChangedCallback;
import com.neuromd.neurosdk.BaseDoubleChannel;
import com.neuromd.neurosdk.ChannelInfo;
import com.neuromd.neurosdk.Device;
import com.neuromd.neurosdk.DoubleDataChannel;
import com.neuromd.neurosdk.Filter;

public class SignalChannel
extends BaseDoubleChannel {
    private final Device mDevice;
    private final AnyChannel mAnyChannel;
    private final DoubleDataChannel mDataChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback(){

        @Override
        public void onDataLengthChanged(int dataLength) {
            SignalChannel.this.dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public SignalChannel(Device device) {
        this.mDevice = device;
        this.mAnyChannel = new AnyChannel(SignalChannel.createSignalDoubleChannel(device.devicePtr()), this.lengthChangedCallback);
        this.mDataChannel = new DoubleDataChannel(this.mAnyChannel);
    }

    public SignalChannel(Device device, ChannelInfo info) {
        this.mDevice = device;
        this.mAnyChannel = new AnyChannel(SignalChannel.createSignalDoubleChannelInfo(device.devicePtr(), info), this.lengthChangedCallback);
        this.mDataChannel = new DoubleDataChannel(this.mAnyChannel);
    }

    public SignalChannel(Device device, ChannelInfo info, Filter[] filters) {
        this.mDevice = device;
        this.mAnyChannel = new AnyChannel(SignalChannel.createSignalDoubleChannelInfoFilters(device.devicePtr(), info, filters), this.lengthChangedCallback);
        this.mDataChannel = new DoubleDataChannel(this.mAnyChannel);
    }

    public SignalChannel(Device device, Filter[] filters) {
        this.mDevice = device;
        this.mAnyChannel = new AnyChannel(SignalChannel.createSignalDoubleChannelFilters(device.devicePtr(), filters), this.lengthChangedCallback);
        this.mDataChannel = new DoubleDataChannel(this.mAnyChannel);
    }

    @Override
    public void close() {
        this.mAnyChannel.close();
    }

    @Override
    public ChannelInfo info() {
        return this.mAnyChannel.info();
    }

    @Override
    public int totalLength() {
        return this.mAnyChannel.totalLength();
    }

    public int bufferSize() {
        return SignalChannel.SignalDoubleChannelGetBufferSize(this.channelPtr());
    }

    @Override
    public float samplingFrequency() {
        return this.mAnyChannel.samplingFrequency();
    }

    @Override
    public long channelPtr() {
        return this.mAnyChannel.channelPtr();
    }

    @Override
    public double[] readData(int offset, int length) {
        return this.mDataChannel.readData(offset, length);
    }

    private static native long createSignalDoubleChannel(long var0);

    private static native long createSignalDoubleChannelInfo(long var0, ChannelInfo var2);

    private static native long createSignalDoubleChannelInfoFilters(long var0, ChannelInfo var2, Filter[] var3);

    private static native long createSignalDoubleChannelFilters(long var0, Filter[] var2);

    private static native int SignalDoubleChannelGetBufferSize(long var0);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

