/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.AnyChannel;
import com.neuromd.neurosdk.AnyChannelLengthChangedCallback;
import com.neuromd.neurosdk.BaseChannel;
import com.neuromd.neurosdk.BaseDoubleChannel;
import com.neuromd.neurosdk.ChannelInfo;
import com.neuromd.neurosdk.ElectrodesStateChannel;
import com.neuromd.neurosdk.IntDataChannel;

public class RPeakChannel
extends BaseChannel {
    private final BaseDoubleChannel mSignalDoubleChannel;
    private final ElectrodesStateChannel mElectrodeChannel;
    private final AnyChannel mAnyChannel;
    private final IntDataChannel mDataChannel;

    public RPeakChannel(BaseDoubleChannel signalDoubleChannel) {
        this.mSignalDoubleChannel = signalDoubleChannel;
        this.mElectrodeChannel = null;
        this.mAnyChannel = new AnyChannel(RPeakChannel.createRPeakChannel(this.mSignalDoubleChannel.channelPtr()), new AnyChannelLengthChangedCallback(){

            @Override
            public void onDataLengthChanged(int dataLength) {
                RPeakChannel.this.dataLengthChanged.sendNotification(this, dataLength);
            }
        });
        this.mDataChannel = new IntDataChannel(this.mAnyChannel);
    }

    public RPeakChannel(BaseDoubleChannel signalDoubleChannel, ElectrodesStateChannel electrodeChannel) {
        this.mSignalDoubleChannel = signalDoubleChannel;
        this.mElectrodeChannel = electrodeChannel;
        this.mAnyChannel = new AnyChannel(RPeakChannel.createRPeakChannelElectrodeState(this.mSignalDoubleChannel.channelPtr(), this.mElectrodeChannel.channelPtr()), new AnyChannelLengthChangedCallback(){

            @Override
            public void onDataLengthChanged(int dataLength) {
                RPeakChannel.this.dataLengthChanged.sendNotification(this, dataLength);
            }
        });
        this.mDataChannel = new IntDataChannel(this.mAnyChannel);
    }

    @Override
    public void close() {
        this.mAnyChannel.close();
    }

    @Override
    public ChannelInfo info() {
        return this.mAnyChannel.info();
    }

    @Override
    public int totalLength() {
        return this.mAnyChannel.totalLength();
    }

    @Override
    public float samplingFrequency() {
        return this.mAnyChannel.samplingFrequency();
    }

    @Override
    public long channelPtr() {
        return this.mAnyChannel.channelPtr();
    }

    public int[] readData(int offset, int length) {
        return this.mDataChannel.readData(offset, length);
    }

    private static native long createRPeakChannel(long var0);

    private static native long createRPeakChannelElectrodeState(long var0, long var2);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

