/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.ADCInput;
import com.neuromd.neurosdk.AccelerometerSensitivity;
import com.neuromd.neurosdk.Device;
import com.neuromd.neurosdk.DeviceState;
import com.neuromd.neurosdk.ExternalSwitchInput;
import com.neuromd.neurosdk.FirmwareMode;
import com.neuromd.neurosdk.FirmwareVersion;
import com.neuromd.neurosdk.Gain;
import com.neuromd.neurosdk.GyroscopeSensitivity;
import com.neuromd.neurosdk.MotionAssistantParams;
import com.neuromd.neurosdk.ParameterName;
import com.neuromd.neurosdk.SamplingFrequency;
import com.neuromd.neurosdk.StimulationParams;
import com.neuromd.neurosdk.StimulatorDeviceState;

final class ParameterTypeInfo {
    private final ParamReader mReader;
    private final ParamSetter mSetter;

    ParamReader paramReader() {
        return this.mReader;
    }

    ParamSetter paramSetter() {
        return this.mSetter;
    }

    ParameterTypeInfo(ParameterName parameter) {
        switch (parameter) {
            case Name: {
                this.mReader = new ParamReader(){

                    @Override
                    public Object readParam(Device device) {
                        return ParameterTypeInfo.deviceReadName(device.devicePtr());
                    }
                };
                this.mSetter = new ParamSetter(){

                    @Override
                    public void setParam(Device device, Object value) {
                        throw new UnsupportedOperationException("Unable to set device name");
                    }
                };
                break;
            }
            case State: {
                this.mReader = new ParamReader(){

                    @Override
                    public Object readParam(Device device) {
                        return ParameterTypeInfo.deviceReadState(device.devicePtr());
                    }
                };
                this.mSetter = new ParamSetter(){

                    @Override
                    public void setParam(Device device, Object value) {
                        throw new UnsupportedOperationException("Unable to set device state");
                    }
                };
                break;
            }
            case Address: {
                this.mReader = new ParamReader(){

                    @Override
                    public Object readParam(Device device) {
                        return ParameterTypeInfo.deviceReadAddress(device.devicePtr());
                    }
                };
                this.mSetter = new ParamSetter(){

                    @Override
                    public void setParam(Device device, Object value) {
                        throw new UnsupportedOperationException("Unable to set device address");
                    }
                };
                break;
            }
            case SerialNumber: {
                this.mReader = new ParamReader(){

                    @Override
                    public Object readParam(Device device) {
                        return ParameterTypeInfo.deviceReadSerialNumber(device.devicePtr());
                    }
                };
                this.mSetter = new ParamSetter(){

                    @Override
                    public void setParam(Device device, Object value) {
                        throw new UnsupportedOperationException("Unable to set device serial number");
                    }
                };
                break;
            }
            case HardwareFilterState: {
                this.mReader = new ParamReader(){

                    @Override
                    public Object readParam(Device device) {
                        return ParameterTypeInfo.deviceReadHardwareFilterState(device.devicePtr());
                    }
                };
                this.mSetter = new ParamSetter(){

                    @Override
                    public void setParam(Device device, Object value) {
                        ParameterTypeInfo.deviceSetHardwareFilterState(device.devicePtr(), (Boolean)value);
                    }
                };
                break;
            }
            case FirmwareVersion: {
                this.mReader = new ParamReader(){

                    @Override
                    public Object readParam(Device device) {
                        return ParameterTypeInfo.deviceReadFirmwareVersion(device.devicePtr());
                    }
                };
                this.mSetter = new ParamSetter(){

                    @Override
                    public void setParam(Device device, Object value) {
                        throw new UnsupportedOperationException("Unable to set firmware version: parameter is readonly.");
                    }
                };
                break;
            }
            case FirmwareMode: {
                this.mReader = new ParamReader(){

                    @Override
                    public Object readParam(Device device) {
                        return ParameterTypeInfo.deviceReadFirmwareMode(device.devicePtr());
                    }
                };
                this.mSetter = new ParamSetter(){

                    @Override
                    public void setParam(Device device, Object value) {
                        ParameterTypeInfo.deviceSetFirmwareMode(device.devicePtr(), (FirmwareMode)((Object)value));
                    }
                };
                break;
            }
            case SamplingFrequency: {
                this.mReader = new ParamReader(){

                    @Override
                    public Object readParam(Device device) {
                        return ParameterTypeInfo.deviceReadSamplingFrequency(device.devicePtr());
                    }
                };
                this.mSetter = new ParamSetter(){

                    @Override
                    public void setParam(Device device, Object value) {
                        ParameterTypeInfo.deviceSetSamplingFrequency(device.devicePtr(), (SamplingFrequency)((Object)value));
                    }
                };
                break;
            }
            case Gain: {
                this.mReader = new ParamReader(){

                    @Override
                    public Object readParam(Device device) {
                        return ParameterTypeInfo.deviceReadGain(device.devicePtr());
                    }
                };
                this.mSetter = new ParamSetter(){

                    @Override
                    public void setParam(Device device, Object value) {
                        ParameterTypeInfo.deviceSetGain(device.devicePtr(), (Gain)((Object)value));
                    }
                };
                break;
            }
            case Offset: {
                this.mReader = new ParamReader(){

                    @Override
                    public Object readParam(Device device) {
                        return ParameterTypeInfo.deviceReadOffset(device.devicePtr());
                    }
                };
                this.mSetter = new ParamSetter(){

                    @Override
                    public void setParam(Device device, Object value) {
                        ParameterTypeInfo.deviceSetOffset(device.devicePtr(), (Byte)value);
                    }
                };
                break;
            }
            case ExternalSwitchState: {
                this.mReader = new ParamReader(){

                    @Override
                    public Object readParam(Device device) {
                        return ParameterTypeInfo.deviceReadExternalSwitchState(device.devicePtr());
                    }
                };
                this.mSetter = new ParamSetter(){

                    @Override
                    public void setParam(Device device, Object value) {
                        ParameterTypeInfo.deviceSetExternalSwitchState(device.devicePtr(), (ExternalSwitchInput)((Object)value));
                    }
                };
                break;
            }
            case ADCInputState: {
                this.mReader = new ParamReader(){

                    @Override
                    public Object readParam(Device device) {
                        return ParameterTypeInfo.deviceReadADCInputState(device.devicePtr());
                    }
                };
                this.mSetter = new ParamSetter(){

                    @Override
                    public void setParam(Device device, Object value) {
                        ParameterTypeInfo.deviceSetADCInputState(device.devicePtr(), (ADCInput)((Object)value));
                    }
                };
                break;
            }
            case AccelerometerSens: {
                this.mReader = new ParamReader(){

                    @Override
                    public Object readParam(Device device) {
                        return ParameterTypeInfo.deviceReadAccelerometerSens(device.devicePtr());
                    }
                };
                this.mSetter = new ParamSetter(){

                    @Override
                    public void setParam(Device device, Object value) {
                        ParameterTypeInfo.deviceSetAccelerometerSens(device.devicePtr(), (AccelerometerSensitivity)((Object)value));
                    }
                };
                break;
            }
            case GyroscopeSens: {
                this.mReader = new ParamReader(){

                    @Override
                    public Object readParam(Device device) {
                        return ParameterTypeInfo.deviceReadGyroscopeSens(device.devicePtr());
                    }
                };
                this.mSetter = new ParamSetter(){

                    @Override
                    public void setParam(Device device, Object value) {
                        ParameterTypeInfo.deviceSetGyroscopeSens(device.devicePtr(), (GyroscopeSensitivity)((Object)value));
                    }
                };
                break;
            }
            case StimulatorAndMAState: {
                this.mReader = new ParamReader(){

                    @Override
                    public Object readParam(Device device) {
                        return ParameterTypeInfo.deviceReadStimulatorAndMAState(device.devicePtr());
                    }
                };
                this.mSetter = new ParamSetter(){

                    @Override
                    public void setParam(Device device, Object value) {
                        throw new UnsupportedOperationException("Unable to set stimulation state");
                    }
                };
                break;
            }
            case StimulatorParamPack: {
                this.mReader = new ParamReader(){

                    @Override
                    public Object readParam(Device device) {
                        return ParameterTypeInfo.deviceReadStimulatorParamPack(device.devicePtr());
                    }
                };
                this.mSetter = new ParamSetter(){

                    @Override
                    public void setParam(Device device, Object value) {
                        ParameterTypeInfo.deviceSetStimulatorParamPack(device.devicePtr(), (StimulationParams)value);
                    }
                };
                break;
            }
            case MotionAssistantParamPack: {
                this.mReader = new ParamReader(){

                    @Override
                    public Object readParam(Device device) {
                        return ParameterTypeInfo.deviceReadMotionAssistantParamPack(device.devicePtr());
                    }
                };
                this.mSetter = new ParamSetter(){

                    @Override
                    public void setParam(Device device, Object value) {
                        ParameterTypeInfo.deviceSetMotionAssistantParamPack(device.devicePtr(), (MotionAssistantParams)value);
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("ParameterName");
            }
        }
    }

    private static native String deviceReadName(long var0);

    private static native DeviceState deviceReadState(long var0);

    private static native String deviceReadAddress(long var0);

    private static native String deviceReadSerialNumber(long var0);

    private static native boolean deviceReadHardwareFilterState(long var0);

    private static native FirmwareMode deviceReadFirmwareMode(long var0);

    private static native FirmwareVersion deviceReadFirmwareVersion(long var0);

    private static native SamplingFrequency deviceReadSamplingFrequency(long var0);

    private static native Gain deviceReadGain(long var0);

    private static native byte deviceReadOffset(long var0);

    private static native ExternalSwitchInput deviceReadExternalSwitchState(long var0);

    private static native ADCInput deviceReadADCInputState(long var0);

    private static native AccelerometerSensitivity deviceReadAccelerometerSens(long var0);

    private static native GyroscopeSensitivity deviceReadGyroscopeSens(long var0);

    private static native StimulatorDeviceState deviceReadStimulatorAndMAState(long var0);

    private static native StimulationParams deviceReadStimulatorParamPack(long var0);

    private static native MotionAssistantParams deviceReadMotionAssistantParamPack(long var0);

    private static native void deviceSetHardwareFilterState(long var0, boolean var2);

    private static native void deviceSetFirmwareMode(long var0, FirmwareMode var2);

    private static native void deviceSetSamplingFrequency(long var0, SamplingFrequency var2);

    private static native void deviceSetGain(long var0, Gain var2);

    private static native void deviceSetOffset(long var0, byte var2);

    private static native void deviceSetExternalSwitchState(long var0, ExternalSwitchInput var2);

    private static native void deviceSetADCInputState(long var0, ADCInput var2);

    private static native void deviceSetAccelerometerSens(long var0, AccelerometerSensitivity var2);

    private static native void deviceSetGyroscopeSens(long var0, GyroscopeSensitivity var2);

    private static native void deviceSetStimulatorParamPack(long var0, StimulationParams var2);

    private static native void deviceSetMotionAssistantParamPack(long var0, MotionAssistantParams var2);

    static interface ParamSetter {
        public void setParam(Device var1, Object var2);
    }

    static interface ParamReader {
        public Object readParam(Device var1);
    }
}

