/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.ParameterName;
import java.util.concurrent.atomic.AtomicBoolean;

final class ParameterEventListener {
    private final Callback mCallback;
    private final AtomicBoolean mIsRunning = new AtomicBoolean(true);
    private final long mQueuePtr;
    private final Thread mListenerThread;

    ParameterEventListener(Callback callback) {
        this.mCallback = callback;
        this.mQueuePtr = ParameterEventListener.createListenerQueue();
        this.mListenerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (ParameterEventListener.this.mIsRunning.get()) {
                    ParameterName parameter = ParameterEventListener.waitForEvent(ParameterEventListener.this.mQueuePtr);
                    if (!ParameterEventListener.this.mIsRunning.get()) {
                        return;
                    }
                    if (parameter == null) continue;
                    ParameterEventListener.this.mCallback.onEvent(parameter);
                }
            }
        });
        this.mListenerThread.start();
    }

    public void finalize() throws Throwable {
        if (this.mIsRunning.get()) {
            this.close();
        }
        super.finalize();
    }

    public void close() throws InterruptedException {
        if (!this.mIsRunning.get()) {
            return;
        }
        this.mIsRunning.set(false);
        ParameterEventListener.interruptWait(this.mQueuePtr);
        this.mListenerThread.join();
        ParameterEventListener.deleteListenerQueue(this.mQueuePtr);
    }

    public long queuePtr() {
        return this.mQueuePtr;
    }

    private static native long createListenerQueue();

    private static native ParameterName waitForEvent(long var0);

    private static native void interruptWait(long var0);

    private static native void deleteListenerQueue(long var0);

    public static interface Callback {
        public void onEvent(ParameterName var1);
    }
}

