/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.AnyChannel;
import com.neuromd.neurosdk.AnyChannelLengthChangedCallback;
import com.neuromd.neurosdk.BaseChannel;
import com.neuromd.neurosdk.ChannelInfo;
import com.neuromd.neurosdk.Device;
import com.neuromd.neurosdk.Quaternion;

public class OrientationChannel
extends BaseChannel {
    private final Device mDevice;
    private final AnyChannel mAnyChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback(){

        @Override
        public void onDataLengthChanged(int dataLength) {
            OrientationChannel.this.dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public OrientationChannel(Device device) {
        this.mDevice = device;
        this.mAnyChannel = new AnyChannel(OrientationChannel.createOrientationChannel(device.devicePtr()), this.lengthChangedCallback);
    }

    @Override
    public void close() {
        this.mAnyChannel.close();
    }

    @Override
    public ChannelInfo info() {
        return this.mAnyChannel.info();
    }

    @Override
    public int totalLength() {
        return this.mAnyChannel.totalLength();
    }

    public int bufferSize() {
        return OrientationChannel.getBufferSize(this.channelPtr());
    }

    @Override
    public float samplingFrequency() {
        return this.mAnyChannel.samplingFrequency();
    }

    @Override
    public long channelPtr() {
        return this.mAnyChannel.channelPtr();
    }

    public Quaternion[] readData(int offset, int length) {
        return OrientationChannel.readData(this.mAnyChannel.channelPtr(), offset, length);
    }

    private static native long createOrientationChannel(long var0);

    private static native int getBufferSize(long var0);

    private static native Quaternion[] readData(long var0, int var2, int var3);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

