/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.EegIndexChannel;
import com.neuromd.neurosdk.SubscribersNotifier;

public final class MeditationAnalyzer {
    private boolean mIsClosed = false;
    private final EegIndexChannel mIndexChannel;
    private final long mAnalyzerPtr;
    private final long mLevelListenerPtr;
    private final long mLevelProgressListenerPtr;
    public final SubscribersNotifier<Integer> levelChanged = new SubscribersNotifier();
    public final SubscribersNotifier<Double> levelProgressChanged = new SubscribersNotifier();

    public MeditationAnalyzer(EegIndexChannel indexChannel) {
        if (indexChannel.channelPtr() == 0L) {
            throw new IllegalArgumentException("Index channel pointer is null");
        }
        this.mIndexChannel = indexChannel;
        this.mAnalyzerPtr = MeditationAnalyzer.create(this.mIndexChannel.channelPtr());
        this.mLevelListenerPtr = this.subscribeLevelChanged(this.mAnalyzerPtr);
        this.mLevelProgressListenerPtr = this.subscribeLevelProgressChanged(this.mAnalyzerPtr);
    }

    public void close() {
        if (!this.mIsClosed) {
            this.mIsClosed = true;
            MeditationAnalyzer.freeLevelListenerHandle(this.mLevelListenerPtr);
            MeditationAnalyzer.freeLevelProgressListenerHandle(this.mLevelProgressListenerPtr);
            MeditationAnalyzer.AnalyzerDelete(this.mAnalyzerPtr);
        }
    }

    private void throwIfClosed() {
        if (this.mIsClosed) {
            throw new UnsupportedOperationException("MeditationAnalyzer is closed");
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private void onLevelChanged(long analyzerPtr, int level) {
        if (analyzerPtr != this.mAnalyzerPtr || this.mIsClosed) {
            return;
        }
        this.levelChanged.sendNotification(this, level);
    }

    private void onLevelProgressChanged(long analyzerPtr, double levelProgress) {
        if (analyzerPtr != this.mAnalyzerPtr || this.mIsClosed) {
            return;
        }
        this.levelProgressChanged.sendNotification(this, levelProgress);
    }

    public int level() {
        this.throwIfClosed();
        return MeditationAnalyzer.level(this.mAnalyzerPtr);
    }

    public double levelProgress() {
        this.throwIfClosed();
        return MeditationAnalyzer.levelProgress(this.mAnalyzerPtr);
    }

    private static native long create(long var0);

    private static native int level(long var0);

    private static native double levelProgress(long var0);

    private static native void AnalyzerDelete(long var0);

    private native long subscribeLevelChanged(long var1);

    private native long subscribeLevelProgressChanged(long var1);

    private static native void freeLevelListenerHandle(long var0);

    private static native void freeLevelProgressListenerHandle(long var0);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

