/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.AnyChannel;
import com.neuromd.neurosdk.AnyChannelLengthChangedCallback;
import com.neuromd.neurosdk.BaseChannel;
import com.neuromd.neurosdk.ChannelInfo;
import com.neuromd.neurosdk.Device;
import com.neuromd.neurosdk.MEMS;

public class MEMSChannel
extends BaseChannel {
    private final Device mDevice;
    private final AnyChannel mAnyChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback(){

        @Override
        public void onDataLengthChanged(int dataLength) {
            MEMSChannel.this.dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public MEMSChannel(Device device) {
        this.mDevice = device;
        this.mAnyChannel = new AnyChannel(MEMSChannel.createMemsChannel(device.devicePtr()), this.lengthChangedCallback);
    }

    @Override
    public void close() {
        this.mAnyChannel.close();
    }

    @Override
    public ChannelInfo info() {
        return this.mAnyChannel.info();
    }

    @Override
    public int totalLength() {
        return this.mAnyChannel.totalLength();
    }

    public int bufferSize() {
        return MEMSChannel.getBufferSize(this.channelPtr());
    }

    @Override
    public float samplingFrequency() {
        return this.mAnyChannel.samplingFrequency();
    }

    @Override
    public long channelPtr() {
        return this.mAnyChannel.channelPtr();
    }

    public MEMS[] readData(int offset, int length) {
        return MEMSChannel.readData(this.mAnyChannel.channelPtr(), offset, length);
    }

    private static native long createMemsChannel(long var0);

    private static native int getBufferSize(long var0);

    private static native MEMS[] readData(long var0, int var2, int var3);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

