/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import java.util.concurrent.atomic.AtomicBoolean;

final class LengthEventListener {
    private final Callback mCallback;
    private final AtomicBoolean mIsRunning = new AtomicBoolean(true);
    private final long mQueuePtr;
    private final Thread mListenerThread;

    LengthEventListener(Callback callback) {
        this.mCallback = callback;
        this.mQueuePtr = LengthEventListener.createListenerQueue();
        this.mListenerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (LengthEventListener.this.mIsRunning.get()) {
                    try {
                        int length = LengthEventListener.waitForEvent(LengthEventListener.this.mQueuePtr);
                        if (!LengthEventListener.this.mIsRunning.get()) {
                            return;
                        }
                        LengthEventListener.this.mCallback.onEvent(length);
                    }
                    catch (Throwable e) {}
                }
            }
        });
        this.mListenerThread.start();
    }

    public void finalize() throws Throwable {
        if (this.mIsRunning.get()) {
            this.close();
        }
        super.finalize();
    }

    public void close() throws InterruptedException {
        if (!this.mIsRunning.get()) {
            return;
        }
        this.mIsRunning.set(false);
        LengthEventListener.interruptWait(this.mQueuePtr);
        this.mListenerThread.join();
        LengthEventListener.deleteListenerQueue(this.mQueuePtr);
    }

    public long queuePtr() {
        return this.mQueuePtr;
    }

    private static native long createListenerQueue();

    private static native int waitForEvent(long var0);

    private static native void interruptWait(long var0);

    private static native void deleteListenerQueue(long var0);

    public static interface Callback {
        public void onEvent(int var1);
    }
}

