/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import java.util.concurrent.atomic.AtomicBoolean;

final class EventListener {
    private final Callback mCallback;
    private final AtomicBoolean mIsRunning = new AtomicBoolean(true);
    private final long mQueuePtr;
    private final Thread mListenerThread;

    EventListener(Callback callback) {
        this.mCallback = callback;
        this.mQueuePtr = EventListener.createListenerQueue();
        this.mListenerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (EventListener.this.mIsRunning.get()) {
                    EventListener.waitForEvent(EventListener.this.mQueuePtr);
                    if (!EventListener.this.mIsRunning.get()) {
                        return;
                    }
                    EventListener.this.mCallback.onEvent();
                }
            }
        });
        this.mListenerThread.start();
    }

    public void finalize() throws Throwable {
        if (this.mIsRunning.get()) {
            this.close();
        }
        super.finalize();
    }

    public void close() throws InterruptedException {
        if (!this.mIsRunning.get()) {
            return;
        }
        this.mIsRunning.set(false);
        EventListener.interruptWait(this.mQueuePtr);
        this.mListenerThread.join();
        EventListener.deleteListenerQueue(this.mQueuePtr);
    }

    public long queuePtr() {
        return this.mQueuePtr;
    }

    private static native long createListenerQueue();

    private static native void waitForEvent(long var0);

    private static native void interruptWait(long var0);

    private static native void deleteListenerQueue(long var0);

    public static interface Callback {
        public void onEvent();
    }
}

