/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.AnyChannel;
import com.neuromd.neurosdk.AnyChannelLengthChangedCallback;
import com.neuromd.neurosdk.BaseDoubleChannel;
import com.neuromd.neurosdk.ChannelInfo;
import com.neuromd.neurosdk.DoubleDataChannel;
import com.neuromd.neurosdk.EmulationSine;
import java.util.List;

public class EmulationChannel
extends BaseDoubleChannel {
    private final AnyChannel mAnyChannel;
    private final DoubleDataChannel mDataChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback(){

        @Override
        public void onDataLengthChanged(int dataLength) {
            EmulationChannel.this.dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public EmulationChannel(List<EmulationSine> components, float samplingFrequency, int initialLength) {
        this.mAnyChannel = new AnyChannel(EmulationChannel.createEmulationChannel(components, samplingFrequency, initialLength), this.lengthChangedCallback);
        this.mDataChannel = new DoubleDataChannel(this.mAnyChannel);
    }

    @Override
    public void close() {
        this.mAnyChannel.close();
    }

    @Override
    public ChannelInfo info() {
        return this.mAnyChannel.info();
    }

    @Override
    public int totalLength() {
        return this.mAnyChannel.totalLength();
    }

    @Override
    public float samplingFrequency() {
        return this.mAnyChannel.samplingFrequency();
    }

    @Override
    public long channelPtr() {
        return this.mAnyChannel.channelPtr();
    }

    @Override
    public double[] readData(int offset, int length) {
        return this.mDataChannel.readData(offset, length);
    }

    public void startTimer() {
        EmulationChannel.startTimer(this.channelPtr());
    }

    public void stopTimer() {
        EmulationChannel.stopTimer(this.channelPtr());
    }

    public void reset() {
        EmulationChannel.reset(this.channelPtr());
    }

    private static native long createEmulationChannel(List<EmulationSine> var0, float var1, int var2);

    private static native void startTimer(long var0);

    private static native void stopTimer(long var0);

    private static native void reset(long var0);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

