/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.AnyChannel;
import com.neuromd.neurosdk.AnyChannelLengthChangedCallback;
import com.neuromd.neurosdk.BaseChannel;
import com.neuromd.neurosdk.ChannelInfo;
import com.neuromd.neurosdk.EegIndexChannel;
import com.neuromd.neurosdk.EegIndexMode;
import com.neuromd.neurosdk.EmotionalState;
import com.neuromd.neurosdk.EmotionalStateName;

public class EmotionalStateChannel
extends BaseChannel {
    private final AnyChannel mAnyChannel;
    private final EegIndexChannel mIndexChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback(){

        @Override
        public void onDataLengthChanged(int dataLength) {
            EmotionalStateChannel.this.dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public EmotionalStateChannel(EegIndexChannel indexChannel) {
        this.mIndexChannel = indexChannel;
        this.mAnyChannel = new AnyChannel(EmotionalStateChannel.createEmotionStateChannel(this.mIndexChannel.channelPtr()), this.lengthChangedCallback);
    }

    @Override
    public void close() {
        this.mAnyChannel.close();
    }

    @Override
    public ChannelInfo info() {
        return this.mAnyChannel.info();
    }

    @Override
    public int totalLength() {
        return this.mAnyChannel.totalLength();
    }

    @Override
    public float samplingFrequency() {
        return this.mAnyChannel.samplingFrequency();
    }

    @Override
    public long channelPtr() {
        return this.mAnyChannel.channelPtr();
    }

    public EmotionalState[] readData(int offset, int length) {
        return EmotionalStateChannel.readData(this.channelPtr(), offset, length);
    }

    public int bufferSize() {
        return EmotionalStateChannel.getBufferSize(this.channelPtr());
    }

    public EegIndexMode getMode() {
        return EmotionalStateChannel.getEegIndexMode(this.channelPtr());
    }

    public static EmotionalStateName valueToName(EmotionalState value) {
        if (value.relaxation() >= 0.0 && value.relaxation() < 0.1 || value.concentration() >= 0.0 && value.concentration() < 0.1) {
            return EmotionalStateName.NormalActivation;
        }
        if (value.relaxation() >= 0.0) {
            return EmotionalStateName.Relaxation;
        }
        return EmotionalStateName.Concentration;
    }

    private static native long createEmotionStateChannel(long var0);

    private static native int getBufferSize(long var0);

    private static native EegIndexMode getEegIndexMode(long var0);

    private static native EmotionalState[] readData(long var0, int var2, int var3);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

