/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.AnyChannel;
import com.neuromd.neurosdk.AnyChannelLengthChangedCallback;
import com.neuromd.neurosdk.BaseChannel;
import com.neuromd.neurosdk.ChannelInfo;
import com.neuromd.neurosdk.Device;
import com.neuromd.neurosdk.ElectrodeState;

public class ElectrodesStateChannel
extends BaseChannel {
    private final Device mDevice;
    private final AnyChannel mAnyChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback(){

        @Override
        public void onDataLengthChanged(int dataLength) {
            ElectrodesStateChannel.this.dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public ElectrodesStateChannel(Device device) {
        this.mDevice = device;
        this.mAnyChannel = new AnyChannel(ElectrodesStateChannel.createElectrodeStateChannel(device.devicePtr()), this.lengthChangedCallback);
    }

    @Override
    public void close() {
        this.mAnyChannel.close();
    }

    @Override
    public ChannelInfo info() {
        return this.mAnyChannel.info();
    }

    @Override
    public int totalLength() {
        return this.mAnyChannel.totalLength();
    }

    public int bufferSize() {
        return ElectrodesStateChannel.ElectrodeStateChannelGetBufferSize(this.channelPtr());
    }

    @Override
    public float samplingFrequency() {
        return this.mAnyChannel.samplingFrequency();
    }

    @Override
    public long channelPtr() {
        return this.mAnyChannel.channelPtr();
    }

    public ElectrodeState[] readData(int offset, int length) {
        return ElectrodesStateChannel.readData(this.mAnyChannel.channelPtr(), offset, length);
    }

    private static native long createElectrodeStateChannel(long var0);

    private static native int ElectrodeStateChannelGetBufferSize(long var0);

    private static native ElectrodeState[] readData(long var0, int var2, int var3);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

