/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.AnyChannel;
import com.neuromd.neurosdk.AnyChannelLengthChangedCallback;
import com.neuromd.neurosdk.BaseChannel;
import com.neuromd.neurosdk.ChannelInfo;
import com.neuromd.neurosdk.EegChannel;
import com.neuromd.neurosdk.EegIndexMode;
import com.neuromd.neurosdk.EegIndexValues;

public final class EegIndexChannel
extends BaseChannel {
    private final AnyChannel mAnyChannel;
    private final EegChannel mT3;
    private final EegChannel mT4;
    private final EegChannel mO1;
    private final EegChannel mO2;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback(){

        @Override
        public void onDataLengthChanged(int dataLength) {
            EegIndexChannel.this.dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public EegIndexChannel(EegChannel t3, EegChannel t4, EegChannel o1, EegChannel o2) {
        this.mT3 = t3;
        this.mT4 = t4;
        this.mO1 = o1;
        this.mO2 = o2;
        this.mAnyChannel = new AnyChannel(EegIndexChannel.create(this.mT3.channelPtr(), this.mT4.channelPtr(), this.mO1.channelPtr(), this.mO2.channelPtr()), this.lengthChangedCallback);
    }

    @Override
    public void close() {
        this.mAnyChannel.close();
    }

    @Override
    public ChannelInfo info() {
        return this.mAnyChannel.info();
    }

    @Override
    public int totalLength() {
        return this.mAnyChannel.totalLength();
    }

    public int bufferSize() {
        return EegIndexChannel.getBufferSize(this.channelPtr());
    }

    @Override
    public float samplingFrequency() {
        return this.mAnyChannel.samplingFrequency();
    }

    @Override
    public long channelPtr() {
        return this.mAnyChannel.channelPtr();
    }

    public EegIndexValues[] readData(int offset, int length) {
        return EegIndexChannel.readData(this.channelPtr(), offset, length);
    }

    public void setDelay(double delay) {
        EegIndexChannel.setDelay(this.channelPtr(), delay);
    }

    public void setWeights(double alpha, double beta, double delta, double theta) {
        EegIndexChannel.setWeightCoefficients(this.channelPtr(), alpha, beta, delta, theta);
    }

    public EegIndexMode getMode() {
        return EegIndexChannel.getEegIndexMode(this.channelPtr());
    }

    private static native long create(long var0, long var2, long var4, long var6);

    private static native EegIndexValues[] readData(long var0, int var2, int var3);

    private static native int getBufferSize(long var0);

    private static native EegIndexMode getEegIndexMode(long var0);

    private static native void setDelay(long var0, double var2);

    private static native void setWeightCoefficients(long var0, double var2, double var4, double var6, double var8);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

