/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.AnyChannel;
import com.neuromd.neurosdk.AnyChannelLengthChangedCallback;
import com.neuromd.neurosdk.BaseDoubleChannel;
import com.neuromd.neurosdk.ChannelInfo;
import com.neuromd.neurosdk.Device;
import com.neuromd.neurosdk.DoubleDataChannel;

public class EegChannel
extends BaseDoubleChannel {
    private Device mDevice;
    private final AnyChannel mAnyChannel;
    private final DoubleDataChannel mDataChannel;
    private BaseDoubleChannel mDoubleChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback(){

        @Override
        public void onDataLengthChanged(int dataLength) {
            EegChannel.this.dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public EegChannel(Device device) {
        this.mDevice = device;
        this.mAnyChannel = new AnyChannel(EegChannel.createEegDoubleChannel(device.devicePtr()), this.lengthChangedCallback);
        this.mDataChannel = new DoubleDataChannel(this.mAnyChannel);
    }

    public EegChannel(Device device, ChannelInfo info) {
        this.mDevice = device;
        this.mAnyChannel = new AnyChannel(EegChannel.createEegDoubleChannelInfo(device.devicePtr(), info), this.lengthChangedCallback);
        this.mDataChannel = new DoubleDataChannel(this.mAnyChannel);
    }

    public EegChannel(BaseDoubleChannel channel) {
        this.mDoubleChannel = channel;
        this.mAnyChannel = new AnyChannel(EegChannel.createEegDoubleChannelDoubleChannel(this.mDoubleChannel.channelPtr()), this.lengthChangedCallback);
        this.mDataChannel = new DoubleDataChannel(this.mAnyChannel);
    }

    @Override
    public void close() {
        this.mAnyChannel.close();
    }

    @Override
    public ChannelInfo info() {
        return this.mAnyChannel.info();
    }

    @Override
    public int totalLength() {
        return this.mAnyChannel.totalLength();
    }

    @Override
    public float samplingFrequency() {
        return this.mAnyChannel.samplingFrequency();
    }

    @Override
    public long channelPtr() {
        return this.mAnyChannel.channelPtr();
    }

    @Override
    public double[] readData(int offset, int length) {
        return this.mDataChannel.readData(offset, length);
    }

    private static native long createEegDoubleChannel(long var0);

    private static native long createEegDoubleChannelInfo(long var0, ChannelInfo var2);

    private static native long createEegDoubleChannelDoubleChannel(long var0);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

