/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.AnyChannel;
import com.neuromd.neurosdk.AnyChannelLengthChangedCallback;
import com.neuromd.neurosdk.ArtifactZone;
import com.neuromd.neurosdk.BaseChannel;
import com.neuromd.neurosdk.ChannelInfo;
import com.neuromd.neurosdk.EegChannel;

public class EegArtifactChannel
extends BaseChannel {
    private final AnyChannel mAnyChannel;
    private final EegChannel mT3;
    private final EegChannel mT4;
    private final EegChannel mO1;
    private final EegChannel mO2;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback(){

        @Override
        public void onDataLengthChanged(int dataLength) {
            EegArtifactChannel.this.dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public EegArtifactChannel(EegChannel t3, EegChannel t4, EegChannel o1, EegChannel o2) {
        this.mT3 = t3;
        this.mT4 = t4;
        this.mO1 = o1;
        this.mO2 = o2;
        this.mAnyChannel = new AnyChannel(EegArtifactChannel.createEegArtifactChannel(this.mT3.channelPtr(), this.mT4.channelPtr(), this.mO1.channelPtr(), this.mO2.channelPtr()), this.lengthChangedCallback);
    }

    @Override
    public void close() {
        this.mAnyChannel.close();
    }

    @Override
    public ChannelInfo info() {
        return this.mAnyChannel.info();
    }

    @Override
    public int totalLength() {
        return this.mAnyChannel.totalLength();
    }

    @Override
    public float samplingFrequency() {
        return this.mAnyChannel.samplingFrequency();
    }

    @Override
    public long channelPtr() {
        return this.mAnyChannel.channelPtr();
    }

    public ArtifactZone[] readData(int offset, int length) {
        return EegArtifactChannel.readData(this.channelPtr(), offset, length);
    }

    public int bufferSize() {
        return EegArtifactChannel.eegArtifactChannelGetBufferSize(this.channelPtr());
    }

    private static native long createEegArtifactChannel(long var0, long var2, long var4, long var6);

    private static native int eegArtifactChannelGetBufferSize(long var0);

    private static native ArtifactZone[] readData(long var0, int var2, int var3);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

